"use strict"
var test = require("tap").test
var Tracker = require("../index.js").Tracker
var TrackerGroup = require("../index.js").TrackerGroup

var timeoutError = new Error("timeout")
var testEvent = function (obj,event,next) {
  var timeout = setTimeout(function(){
    obj.removeListener(event, eventHandler)
    next(timeoutError)
  }, 10)
  var eventHandler = function () {
    var args = Array.prototype.slice.call(arguments)
    args.unshift(null)
    clearTimeout(timeout)
    next.apply(null, args)
  }
  obj.once(event, eventHandler)
}

test("TrackerGroup", function (t) {
  var name = "test"

  var track = new TrackerGroup(name)
  t.is(track.completed(), 0, "Nothing todo is 0 completion")
  testEvent(track, "change", afterFinishEmpty)
  track.finish()
  var a, b
  function afterFinishEmpty(er, onChangeName) {
    t.is(er, null, "finishEmpty: on change event fired")
    t.is(onChangeName, name, "finishEmpty: on change emits the correct name")
    t.is(track.completed(), 1, "finishEmpty: Finishing an empty group actually finishes it")

    track = new TrackerGroup(name)
    a = track.newItem("a", 10, 1)
    b = track.newItem("b", 10, 1)
    t.is(track.completed(), 0, "Initially empty")
    testEvent(track, "change", afterCompleteWork)
    a.completeWork(5)
  }
  function afterCompleteWork(er, onChangeName) {
    t.is(er, null, "on change event fired")
    t.is(onChangeName, "a", "on change emits the correct name")
    t.is(track.completed(), 0.25, "Complete half of one is a quarter overall")
    testEvent(track, "change", afterFinishAll)
    track.finish()
  }
  function afterFinishAll(er, onChangeName) {
    t.is(er, null, "finishAll: on change event fired")
    t.is(onChangeName, name, "finishAll: on change emits the correct name")
    t.is(track.completed(), 1, "Finishing everything ")
    
    track = new TrackerGroup(name)
    a = track.newItem("a", 10, 2)
    b = track.newItem("b", 10, 1)
    t.is(track.completed(), 0, "weighted: Initially empty")
    testEvent(track, "change", afterWeightedCompleteWork)
    a.completeWork(5)
  }
  function afterWeightedCompleteWork(er, onChangeName) {
    t.is(er, null, "weighted: on change event fired")
    t.is(onChangeName, "a", "weighted: on change emits the correct name")
    t.is(Math.round(track.completed()*100), 33, "weighted: Complete half of double weighted")
    testEvent(track, "change", afterWeightedFinishAll)
    track.finish()
  }
  function afterWeightedFinishAll(er, onChangeName) {
    t.is(er, null, "weightedFinishAll: on change event fired")
    t.is(onChangeName, name, "weightedFinishAll: on change emits the correct name")
    t.is(track.completed(), 1, "weightedFinishaAll: Finishing everything ")
    
    track = new TrackerGroup(name)
    a = track.newGroup("a", 10)
    b = track.newGroup("b", 10)
    var a1 = a.newItem("a.1",10)
    a1.completeWork(5)
    t.is(track.completed(), 0.25, "nested: Initially quarter done")
    testEvent(track, "change", afterNestedComplete)
    b.finish()
  }
  function afterNestedComplete(er, onChangeName) {
    t.is(er, null, "nestedComplete: on change event fired")
    t.is(onChangeName, "b", "nestedComplete: on change emits the correct name")
    t.is(track.completed(), 0.75, "nestedComplete: Finishing everything ")
    t.end()
  }
})
