/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_ServiceAffectsBoot.h"

CMPIObjectPath* Boot_OpenDRIM_ServiceAffectsBoot_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_ServiceAffectsBoot& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_ServiceAffectsBoot_classnames[0], OpenDRIM_ServiceAffectsBoot_NAMESPACE);

	if (!instance.AffectedElement_isNULL)
		op.addKey("AffectedElement", instance.AffectedElement);

	if (!instance.AffectingElement_isNULL)
		op.addKey("AffectingElement", instance.AffectingElement);

	_L_;
	return op.getHdl();
}

CMPIInstance* Boot_OpenDRIM_ServiceAffectsBoot_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_ServiceAffectsBoot& instance) {
	_E_;
	Objectpath op(broker, Boot_OpenDRIM_ServiceAffectsBoot_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.ElementEffects_isNULL)
		ci.setProperty("ElementEffects", instance.ElementEffects);

	if (!instance.OtherElementEffectsDescriptions_isNULL)
		ci.setProperty("OtherElementEffectsDescriptions", instance.OtherElementEffectsDescriptions);

	_L_;
	return ci.getHdl();
}

void Boot_OpenDRIM_ServiceAffectsBoot_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_ServiceAffectsBoot& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("AffectedElement", instance.AffectedElement) == OK)
		instance.AffectedElement_isNULL = false;

	if (op.getKey("AffectingElement", instance.AffectingElement) == OK)
		instance.AffectingElement_isNULL = false;

	_L_;
}

void Boot_OpenDRIM_ServiceAffectsBoot_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_ServiceAffectsBoot& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("AffectedElement", instance.AffectedElement) == OK)
		instance.AffectedElement_isNULL = false;

	if (inst.getProperty("AffectingElement", instance.AffectingElement) == OK)
		instance.AffectingElement_isNULL = false;

	if (inst.getProperty("ElementEffects", instance.ElementEffects) == OK)
		instance.ElementEffects_isNULL = false;

	if (inst.getProperty("OtherElementEffectsDescriptions", instance.OtherElementEffectsDescriptions) == OK)
		instance.OtherElementEffectsDescriptions_isNULL = false;

	_L_;
}

