/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


/*
 * @test
 *
 * @summary converted from VM Testbase nsk/jdi/Field/type/type003.
 * VM Testbase keywords: [jpda, jdi]
 * VM Testbase readme:
 * DESCRIPTION
 *     This test checks the type() method of Field interface of
 *     com.sun.jdi package.
 *     nsk/jdi/Field/type003 checks assertion:
 *     public Type type() throws ClassNotLoadedException
 *     1. Throws ClassNotLoadedException for object fields, if it
 *     has not been loaded through the enclosing type's class loader.
 *     Constructor for each class and interface are not triggered, so all
 *     classes are not loaded in debugee and ClassNotLoadedException should be
 *     thrown in debuger VM.
 * COMMENTS
 * To fix the bug 4423695, all previous classes are replaced with only three basic,
 * - Class, Interface, and Array, -
 * applied to inner and outer class types.
 *
 * @library /vmTestbase
 *          /test/lib
 * @run driver jdk.test.lib.FileInstaller . .
 * @build nsk.jdi.Field.type.type003
 *        nsk.jdi.Field.type.type003a
 * @run main/othervm PropertyResolvingWrapper
 *      nsk.jdi.Field.type.type003
 *      -verbose
 *      -arch=${os.family}-${os.simpleArch}
 *      -waittime=5
 *      -debugee.vmkind=java
 *      -transport.address=dynamic
 *      "-debugee.vmkeys=${test.vm.opts} ${test.java.opts}"
 */

