##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import redhat


class RedhatParserTestCase(unittest.TestCase):

    ## Initial Setup
    redhat_parser_obj = redhat.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/msg00010.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.redhat_parser_obj, 'Html_content', self.Html_content)


    def test_getCVE(self):
        print "\nTesting Redhat Parser Test Suite ..."
        req_out_put = 'CVE-2008-4770'

        out_put = self.redhat_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'RHSA-2009:0261-01'

        out_put = self.redhat_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'vnc'

        out_put = self.redhat_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription(self):
        req_out_put = "  Virtual Network Computing (VNC) is a remote display system which allows you\n  to view a computer's  &qt desktop &qt  environment not only on the machine where it\n  is running, but from anywhere on the Internet and from a wide variety of\n  machine architectures.\n  \n  An insufficient input validation flaw was discovered in the VNC client\n  application, vncviewer. If an attacker could convince a victim to connect\n  to a malicious VNC server, or when an attacker was able to connect to\n  vncviewer running in the  &qt listen &qt  mode, the attacker could cause the\n  victim's vncviewer to crash or, possibly, execute arbitrary code.\n  (CVE-2008-4770)\n  \n  Users of vncviewer should upgrade to these updated packages, which contain\n  a backported patch to resolve this issue. For the update to take effect,\n  all running instances of vncviewer must be restarted after the update is\n  installed.\n"

        out_put = self.redhat_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct(self):
        req_out_put = ['Red Hat Enterprise Linux AS version 3', 'Red Hat Enterprise Linux (v. 5 server)']

        out_put = self.redhat_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM(self):
        req_out_put = {'RHENT_5': ['vnc-4.1.2-14.el5_3.1', 'vnc-debuginfo-4.1.2-14.el5_3.1', 'vnc-server-4.1.2-14.el5_3.1'], 'RHENT_3': ['vnc-4.0-0.beta4.1.8', 'vnc-debuginfo-4.0-0.beta4.1.8', 'vnc-server-4.0-0.beta4.1.8']}

        prod_list = ['Red Hat Enterprise Linux AS version 3', 'Red Hat Enterprise Linux Desktop (v. 5 client)', 'Red Hat Enterprise Linux (v. 5 server)']
        out_put = self.redhat_parser_obj.getRPM(prod_list)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'https://www.redhat.com/archives/rhsa-announce/2009-February/msg00010.html'

        main_url = 'https://www.redhat.com/archives/rhsa-announce/'
        file_name = '2009-February_msg00010.html'
        out_put = self.redhat_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'https://www.redhat.com/archives/rhsa-announce/2009-February/msg00010.html'

        main_url = 'https://www.redhat.com/archives/rhsa-announce'
        file_name = '2009-February_msg00010.html'
        out_put = self.redhat_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        prod_list = ['Red Hat Enterprise Linux AS version 3', 'Red Hat Enterprise Linux Desktop (v. 5 client)', 'Red Hat Enterprise Linux (v. 5 server)']
        setattr(self.redhat_parser_obj, 'Platforms', prod_list)
        out_put = self.redhat_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_getYearLinks(self):
        req_out_put = ['https://www.redhat.com/archives/rhsa-announce/2009-February/thread.html', 'https://www.redhat.com/archives/rhsa-announce/2009-January/thread.html']

        link = './test/unit_test/work/input/redhat-advisory-main.html'
        year = '2009'
        out_put = self.redhat_parser_obj._getYearLinks(link, year)
        self.assertEquals(out_put, req_out_put)


    def test_getEachAdvLink(self):
        req_out_put = ['https://www.redhat.com/archives/rhsa-announce/input/msg00010.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00009.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00008.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00007.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00006.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00005.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00004.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00003.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00002.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00001.html', 'https://www.redhat.com/archives/rhsa-announce/input/msg00000.html']

        link = './test/unit_test/work/input/RHSA-Feb-2009.html'
        out_put = self.redhat_parser_obj._getEachAdvLink(link)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

