# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1894-1 (newt)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64979);
 script_cve_id("CVE-2009-2905");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1894-1 (newt)");

 desc = "The remote host is missing an update to newt
announced via advisory DSA 1894-1.


Miroslav Lichvar discovered that newt, a windowing toolkit, is prone to
a buffer overflow in the content processing code, which can lead to the
execution of arbitrary code.


For the stable distribution (lenny), this problem has been fixed in
version 0.52.2-11.3+lenny1.

For the oldstable distribution (etch), this problem has been fixed in
version 0.52.2-10+etch1.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem will be fixed soon


We recommend that you upgrade your newt packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201894-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1894-1 (newt)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"whiptail", ver:"0.52.2-10+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt0.52", ver:"0.52.2-10+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-dev", ver:"0.52.2-10+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt", ver:"0.52.2-10+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-pic", ver:"0.52.2-10+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"newt-tcl", ver:"0.52.2-10+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt0.52", ver:"0.52.2-11.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-pic", ver:"0.52.2-11.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"whiptail", ver:"0.52.2-11.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt", ver:"0.52.2-11.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"newt-tcl", ver:"0.52.2-11.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-dev", ver:"0.52.2-11.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
