# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8279 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64552);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-8279 (xulrunner)");

 desc = "The remote host is missing an update to xulrunner
announced via advisory FEDORA-2009-8279.

XULRunner provides the XUL Runtime environment for Gecko applications.

Update Information:

Update to new upstream Firefox version 3.5.2, fixing multiple security issues
detailed in the upstream advisories:
http://www.mozilla.org/security/known-vulnerabilities/firefox35.html#firefox3.5.2

Update also includes all packages depending on gecko-libs rebuilt against
new version of Firefox / XULRunner.

ChangeLog:

* Mon Aug  3 2009 Martin Stransky  1.9.1.1-2
- Update to 1.9.1.2
* Fri Jul 17 2009 Martin Stransky  1.9.1.1-1
- Update to 1.9.1.1
* Thu Jul 16 2009 Christopher Aillon  - 1.9.1-5
- Fix for milw0rm 9137
* Tue Jul 14 2009 Jan Horak  - 1.9.1-4
- Fixed multilib issues

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xulrunner' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8279

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8279 (xulrunner)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xulrunner", rpm:"xulrunner~1.9.1.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-devel", rpm:"xulrunner-devel~1.9.1.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-devel-unstable", rpm:"xulrunner-devel-unstable~1.9.1.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-python", rpm:"xulrunner-python~1.9.1.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-python-devel", rpm:"xulrunner-python-devel~1.9.1.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-debuginfo", rpm:"xulrunner-debuginfo~1.9.1.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
