#
#VID 48a59c96-9c6e-11d9-a040-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52149);
 script_bugtraq_id(12791);
 script_cve_id("CVE-2005-0787");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: wine";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: wine

CVE-2005-0787
Wine 20050211 and earlier creates temp files with world readable
permissions and predictable file names, which allows local users to
obtain sensitive information, such as passwords.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.winehq.org/show_bug.cgi?id=2715
http://www.securitytracker.com/alerts/2005/Mar/1013428.html
http://www.zone-h.org/advisories/read/id=7300
http://www.securityfocus.com/bid/12791
http://xforce.iss.net/xforce/xfdb/19697
http://marc.theaimsgroup.com/?l=bugtraq&m=111082537009842
http://www.vuxml.org/freebsd/48a59c96-9c6e-11d9-a040-000a95bc6fae.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: wine";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"wine");
if(!isnull(bver) && revcomp(a:bver, b:"20050310")<0) {
    security_note(0, data:"Package wine version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
