///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_XFORM_CENTER_CHOOSER_H
#define __OVITO_XFORM_CENTER_CHOOSER_H

#include <core/viewport/input/XFormManager.h>
#include <core/gui/CustomButton.h>

namespace Core {

/******************************************************************************
* This combo box lets the user choose the center point for transformations.
******************************************************************************/
class XFormCenterChooser : public CustomButton, private XFormManager::ChangeListener
{
public:
	/// Initializes the combo box.
    XFormCenterChooser(wxWindow* parent);
	/// Destructor.
    virtual ~XFormCenterChooser();

private:

	/// The icon collection.
	IconCollection icons;

	/// Is called when the xform system or the xform center have been changed.
	virtual void onXFormModeChanged();

	/// Is called when the user has choosen an item from the list.
	void onSelectionChanged(wxCommandEvent& event);

	// Any class wishing to process wxWidgets events must use this macro.
	DECLARE_EVENT_TABLE()
};

};

#endif // __OVITO_XFORM_CENTER_CHOOSER_H
