//=======================================================================
// pkgset.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef PACO_PKGSET_H
#define PACO_PKGSET_H

#include "paco/file.h"
#include "paco/basepkg.h"
#include <vector>


namespace Paco {

class Options;
class Pkg;

class PkgSet : public std::vector<Pkg*>
{
	public:

	PkgSet();
	PkgSet(std::vector<std::string> const& args);

	virtual ~PkgSet();

	float sizeInst() const	{ return mSizeInst; }
	float sizeMiss() const	{ return mSizeMiss; }
	long filesInst() const	{ return mFilesInst; }
	long filesMiss() const	{ return mFilesMiss; }

	void listFiles(Options&);
	void listPkgs(Options&);
	void lsPkgs();
	void remove(Options&);
	void add(Pkg*);
	void getFiles(int type = BasePkg::ALL_FILES);
	void getAllPkgs();
	void getPkgs(std::vector<std::string> const& args);
	void printConfOpts();
	void queryFiles(std::vector<std::string> const& args);
	void unlog();
	void printInfo();
	void update(bool allPkgs);
	
	class Sorter
	{
		public:

		Sorter(SortType type);
		bool operator()(Pkg* left, Pkg* right) const;

		private:

		bool (Sorter::*mSortFunc)(Pkg*, Pkg*) const;
		bool sortByName(Pkg* left, Pkg* right) const;
		bool sortBySizeInst(Pkg* left, Pkg* right) const;
		bool sortBySizeMiss(Pkg* left, Pkg* right) const;
		bool sortByFilesMiss(Pkg* left, Pkg* right) const;
		bool sortByFilesInst(Pkg* left, Pkg* right) const;
		bool sortByDate(Pkg* left, Pkg* right) const;

	};	// class PkgSet::Sorter

	private:

	float 	mSizeInst;
	float 	mSizeMiss;
	long	mFilesInst;
	long 	mFilesMiss;

};		// class PkgSet

}		// namespace Paco

#endif  // PACO_PKGSET_H
