# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .product_entity_base_parameters_py3 import ProductEntityBaseParameters


class ProductTagResourceContractProperties(ProductEntityBaseParameters):
    """Product profile.

    All required parameters must be populated in order to send to Azure.

    :param description: Product description. May include HTML formatting tags.
    :type description: str
    :param terms: Product terms of use. Developers trying to subscribe to the
     product will be presented and required to accept these terms before they
     can complete the subscription process.
    :type terms: str
    :param subscription_required: Whether a product subscription is required
     for accessing APIs included in this product. If true, the product is
     referred to as "protected" and a valid subscription key is required for a
     request to an API included in the product to succeed. If false, the
     product is referred to as "open" and requests to an API included in the
     product can be made without a subscription key. If property is omitted
     when creating a new product it's value is assumed to be true.
    :type subscription_required: bool
    :param approval_required: whether subscription approval is required. If
     false, new subscriptions will be approved automatically enabling
     developers to call the product’s APIs immediately after subscribing. If
     true, administrators must manually approve the subscription before the
     developer can any of the product’s APIs. Can be present only if
     subscriptionRequired property is present and has a value of false.
    :type approval_required: bool
    :param subscriptions_limit: Whether the number of subscriptions a user can
     have to this product at the same time. Set to null or omit to allow
     unlimited per user subscriptions. Can be present only if
     subscriptionRequired property is present and has a value of false.
    :type subscriptions_limit: int
    :param state: whether product is published or not. Published products are
     discoverable by users of developer portal. Non published products are
     visible only to administrators. Default state of Product is notPublished.
     Possible values include: 'notPublished', 'published'
    :type state: str or ~azure.mgmt.apimanagement.models.ProductState
    :param id: Identifier of the product in the form of /products/{productId}
    :type id: str
    :param name: Required. Product name.
    :type name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 1},
        'name': {'required': True, 'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'ProductState'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str, description: str=None, terms: str=None, subscription_required: bool=None, approval_required: bool=None, subscriptions_limit: int=None, state=None, id: str=None, **kwargs) -> None:
        super(ProductTagResourceContractProperties, self).__init__(description=description, terms=terms, subscription_required=subscription_required, approval_required=approval_required, subscriptions_limit=subscriptions_limit, state=state, **kwargs)
        self.id = id
        self.name = name
