# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.location = kwargs['location']
        self.type = None
        self.tags = kwargs.get('tags', None)


class Certificate(Resource):
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :param host_names: Host names the certificate applies to.
    :type host_names: list[str]
    :param pfx_blob: Pfx blob.
    :type pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :param password: Certificate password.
    :type password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2018_11_01.models.HostingEnvironmentProfile
    :param key_vault_id: Key Vault Csm resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2018_11_01.models.KeyVaultSecretStatus
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Certificate, self).__init__(**kwargs)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = kwargs.get('host_names', None)
        self.pfx_blob = kwargs.get('pfx_blob', None)
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.password = kwargs.get('password', None)
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.key_vault_secret_status = None
        self.server_farm_id = kwargs.get('server_farm_id', None)


class CertificateCollection(msrest.serialization.Model):
    """Collection of certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2018_11_01.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Certificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.type = None


class CertificatePatchResource(ProxyOnlyResource):
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :param host_names: Host names the certificate applies to.
    :type host_names: list[str]
    :param pfx_blob: Pfx blob.
    :type pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :param password: Certificate password.
    :type password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2018_11_01.models.HostingEnvironmentProfile
    :param key_vault_id: Key Vault Csm resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2018_11_01.models.KeyVaultSecretStatus
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificatePatchResource, self).__init__(**kwargs)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = kwargs.get('host_names', None)
        self.pfx_blob = kwargs.get('pfx_blob', None)
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.password = kwargs.get('password', None)
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.key_vault_secret_status = None
        self.server_farm_id = kwargs.get('server_farm_id', None)


class DefaultErrorResponse(msrest.serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.web.v2018_11_01.models.DefaultErrorResponseError
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'DefaultErrorResponseError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultErrorResponse, self).__init__(**kwargs)
        self.error = None


class DefaultErrorResponseError(msrest.serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :param details:
    :type details: list[~azure.mgmt.web.v2018_11_01.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'innererror': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DefaultErrorResponseErrorDetailsItem]'},
        'innererror': {'key': 'innererror', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultErrorResponseError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = kwargs.get('details', None)
        self.innererror = None


class DefaultErrorResponseErrorDetailsItem(msrest.serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultErrorResponseErrorDetailsItem, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class HostingEnvironmentProfile(msrest.serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID of the App Service Environment.
    :type id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None
