% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_values.R
\name{scale_me}
\alias{scale_me}
\title{scale_me}
\usage{
scale_me(x, min = NULL, max = NULL)
}
\arguments{
\item{x}{vector of predictions}

\item{min}{minimum of \code{x}, Default: NULL}

\item{max}{maximum of \code{x}, Default: NULL}
}
\value{
scaled values of \code{x}
}
\description{
maps all instances in \code{x} to the [0;1] range using the equation:
\cr y = (x-min)/(max-min)
\cr If no values for min and max are given, they are calculated per default as min=min(x) and max=max(x)
}
\details{
if \code{x} is greater (smaller) than \code{max} (\code{min}), its calibrated prediction is set to 1 (0) and warning is triggered.
}
