% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_ard_columns.R
\name{rename_ard_columns}
\alias{rename_ard_columns}
\title{Rename ARD Columns}
\usage{
rename_ard_columns(
  x,
  columns = c(all_ard_groups(), all_ard_variables()),
  unlist = NULL
)
}
\arguments{
\item{x}{(\code{data.frame})\cr
a data frame}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Name of columns to coalesce together and rename.}

\item{unlist}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Columns to unlist. Often useful when performing visual inspection
of the results where the list-columns are more difficult to work with.}
}
\value{
data frame
}
\description{
This function combines a pair of \code{group}/\code{group_level} or \code{variable}/\code{variable_level} columns into a
single column. The \code{group_level} or \code{variable_level} column is renamed according to the value of
the \code{group} or \code{variable} column, respectively.
}
\examples{
ADSL |>
  ard_categorical(by = ARM, variables = AGEGR1) |>
  apply_fmt_fn() |>
  rename_ard_columns(unlist = c(stat, stat_fmt))
}
