% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ape.R
\name{as.phylo.dendrogram}
\alias{as.phylo.dendrogram}
\title{Convert a dendrogram into phylo}
\usage{
as.phylo.dendrogram(x, ...)
}
\arguments{
\item{x}{a dendrogram}

\item{...}{ignored.}
}
\value{
A phylo class object
}
\description{
Based on \link{as.hclust.dendrogram} with \link[ape]{as.phylo.hclust}

In the future I hope a more direct link will be made.
}
\examples{
\dontrun{

library(dendextend)
library(ape)
dend <- iris[1:30, -5] \%>\%
  dist() \%>\%
  hclust() \%>\%
  as.dendrogram()
dend2 <- as.phylo(dend)
plot(dend2, type = "fan")

library(dendextend)
library(ggplot2)
# no longer needed: library(ggdendro)
dend <- iris[1:30, -5] \%>\%
   dist() \%>\%
   hclust() \%>\%
   as.dendrogram()
# there is a bug in the location of the labels 
# If you want to solve it - please send a Pull Request to:
# https://github.com/talgalili/dendextend/
ggplot(dend) +
   scale_y_reverse(expand = c(0.2, 0)) + coord_polar(start = 1, theta="x") 
   
}


# see: https://github.com/klutometis/roxygen/issues/796
#
}
\seealso{
\link{as.dendrogram}, \link{as.hclust}, \link[ape]{as.phylo}
}
