% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_burr.R
\name{dist_burr}
\alias{dist_burr}
\title{The Burr distribution}
\usage{
dist_burr(shape1, shape2, rate = 1)
}
\arguments{
\item{shape1}{parameters. Must be strictly positive.}

\item{shape2}{parameters. Must be strictly positive.}

\item{rate}{an alternative way to specify the scale.}
}
\description{
\lifecycle{stable}
}
\examples{
dist <- dist_burr(shape1 = c(1,1,1,2,3,0.5), shape2 = c(1,2,3,1,1,2))
dist

\dontshow{if (requireNamespace("actuar", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mean(dist)
variance(dist)
support(dist)
generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
\dontshow{\}) # examplesIf}
}
\seealso{
\link[actuar:Burr]{actuar::Burr}
}
