% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifs.R
\name{motifs}
\alias{motifs}
\alias{graph.motifs}
\title{Graph motifs}
\usage{
motifs(graph, size = 3, cut.prob = rep(0, size))
}
\arguments{
\item{graph}{Graph object, the input graph.}

\item{size}{The size of the motif, currently 3 and 4 are supported only.}

\item{cut.prob}{Numeric vector giving the probabilities that the search
graph is cut at a certain level. Its length should be the same as the size
of the motif (the \code{size} argument). By default no cuts are made.}
}
\value{
\code{motifs} returns a numeric vector, the number of occurences of
each motif in the graph. The motifs are ordered by their isomorphism
classes. Note that for unconnected subgraphs, which are not considered to be
motifs, the result will be \code{NA}.
}
\description{
Graph motifs are small connected subgraphs with a well-defined
structure.  These functions search a graph for various motifs.
}
\details{
\code{motifs} searches a graph for motifs of a given size and returns a
numeric vector containing the number of different motifs. The order of
the motifs is defined by their isomorphism class, see
\code{\link{isomorphism_class}}.
}
\examples{
g <- barabasi.game(100)
motifs(g, 3)
count_motifs(g, 3)
sample_motifs(g, 3)
}
\seealso{
\code{\link{isomorphism_class}}

Other graph motifs: \code{\link{count_motifs}},
  \code{\link{sample_motifs}}
}
