% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Grep.R
\name{Grep}
\alias{Grep}
\title{Finds elements in vector or column-names in data.frame/matrix}
\usage{
Grep(x, pattern, subset = TRUE, ignore.case = TRUE, ...)
}
\arguments{
\item{x}{vector, matrix or data.frame.}

\item{pattern}{regular expression to search for}

\item{subset}{If TRUE returns subset of data.frame/matrix otherwise just the matching column names}

\item{ignore.case}{Default ignore case}

\item{...}{Additional arguments to 'grep'}
}
\value{
A data.frame with 2 columns with the indices in the first and the
matching names in the second.
}
\description{
Pattern matching in a vector or column names of a data.frame or matrix.
}
\examples{
data(iris)
head(Grep(iris,"(len)|(sp)"))
}
\seealso{
\code{\link{grep}}, and \code{\link{agrep}} for approximate string
matching,
}
\author{
Klaus K. Holst
}
\keyword{misc}
\keyword{utilities}
