% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.coxph.R
\name{publish.coxph}
\alias{publish.coxph}
\title{Tabulize hazard ratios with confidence intervals and
    p-values.}
\usage{
\method{publish}{coxph}(
  object,
  confint.method,
  pvalue.method,
  print = TRUE,
  factor.reference = "extraline",
  units = NULL,
  probindex = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{coxph} object.}

\item{confint.method}{See \code{regressionTable}}

\item{pvalue.method}{See \code{regressionTable}}

\item{print}{If \code{FALSE} do not print results.}

\item{factor.reference}{See \code{regressionTable}}

\item{units}{See \code{regressionTable}}

\item{probindex}{Logical. If \code{TRUE} show coefficients on probabilistic index scale instead of hazard ratio scale.}

\item{...}{passed to \code{summary.regressionTable} and also to
\code{labelUnits}.}
}
\value{
Table with hazard ratios, confidence intervals and
    p-values.
}
\description{
Tabulize the part of the result of a Cox regression analysis which is commonly shown in publications.
}
\details{
Transforms the log hazard ratios to hazard ratios and returns them
with confidence limits and p-values.  If explanatory variables are
log transformed or log2 transformed, a scaling factor is
multiplied to both the log-hazard ratio and its standard-error.
}
\examples{
library(survival)
data(pbc)
pbc$edema <- factor(pbc$edema,
             levels=c("0","0.5","1"), labels=c("0","0.5","1"))
fit = coxph(Surv(time,status!=0)~age+sex+edema+log(bili)+log(albumin),
            data=na.omit(pbc))
publish(fit)
## forest plot
plot(publish(fit),cex=1.3)

publish(fit,ci.digits=2,pvalue.eps=0.01,pvalue.digits=2,pvalue.stars=TRUE)
publish(fit,ci.digits=2,ci.handler="prettyNum",pvalue.eps=0.01,
        pvalue.digits=2,pvalue.stars=TRUE)
publish(fit, ci.digits=2, ci.handler="sprintf", pvalue.eps=0.01,
        pvalue.digits=2,pvalue.stars=TRUE, ci.trim=FALSE)

fit2 = coxph(Surv(time,status!=0)~age+sex+edema+log(bili,base=2)+log(albumin)+log(protime),
    data=na.omit(pbc))
publish(fit2)

# with cluster variable
fit3 = coxph(Surv(time,status!=0)~age+cluster(sex)+edema+log(bili,base=2)
                                    +log(albumin)+log(protime),
    data=na.omit(pbc))
publish(fit3)

# with strata and cluster variable
fit4 = coxph(Surv(time,status!=0)~age+cluster(sex)+strata(edema)+log(bili,base=2)
                 +log(albumin)+log(protime),
    data=pbc)
publish(fit4)

}
\author{
Thomas Alexander Gerds
}
