// zcat square-4.field.gz | ./navier_stokes_criterion | geo -
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "navier_stokes_criterion.icc"
int main (int argc, char**argv) {
  environment rheolef (argc, argv);
  adapt_option_type options;
  options.err             = (argc > 1) ? atof(argv[1]) : 1e-4;
  options.hmin            = (argc > 2) ? atof(argv[2]) : 0.004;
  options.additional      = "-RelError";
  options.hmax            = 0.1;
  Float Re;
  field uh;
  din >> catchmark("Re") >> Re
      >> catchmark("u")  >> uh;
  field ch = navier_stokes_criterion (Re, uh);
  dout << adapt (ch, options);
}
