///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// mesh metric i/o in mmg3d format
/// =========================================================================

#include "rheolef/field.h"
using namespace rheolef;
using namespace std;

// USAGE:
//   ./metric_interpolate cube-0-metric cube-1-iso.geo 
#include "rheolef.h"

// TODO: check the order of tensor component
ostream&
field::put_mmg3d_metric (ostream& out) const
{
    typedef field::size_type size_type;
    // pour mmg3d-3.1c (7 janv 2007) 
    // sortie de type "medit" avec matrices symetriques avec 6 composantes
    // ou avec matrices completes avec 9 composantes
    bool use_sym_mat = true;
    check_macro (dimension() == 3, "mmg3d: 3D expected, "<<dimension()<<" found");
    check_macro (get_approx() == "P1",
	"mmg3d metric output: P1 approximation expected, `" << get_approx() << "' found");
    check_macro (n_component() == 1 || n_component() == 6, "mmg3d: scalar or tensor expected, "<<n_component() <<" component found");
    size_t ndof = get_space().size_component(0);
    size_t n_comp = n_component();
    size_t type = (n_comp == 1) ? 1 : (use_sym_mat ? 3 : 4);
    out << "MeshVersionFormatted 1" << endl
        << "Dimension 3" << endl
        << "SolAtVertices" << endl
        << ndof << endl
        << "1 " << type << endl;
    if (n_comp == 1) {
        for (size_type idof = 0; idof < ndof; idof++) {
            out << at(idof) << endl;
        }
        out << "End" << endl;
        return out;
    }
    check_macro(n_comp == 6, "Tensorial metric field expected");
    for (size_type idof = 0; idof < ndof; idof++) {
     tensor m = tensor_at (idof);
     if (use_sym_mat) {
       out << m(0,0) << " " << m(0,1) << " " << m(1,1) << " "
	   << m(0,2) << " " << m(1,2) << " " << m(2,2) << endl;
     } else {
       out << m(0,0) << " " << m(0,1) << " " << m(0,2) << " "
	   << m(0,1) << " " << m(1,1) << " " << m(1,2) << " "
	   << m(0,2) << " " << m(1,2) << " " << m(2,2) << endl;
     }
   }
   out << "End" << endl;
   return out;
}
ostream&
field::put_yams_metric (ostream& out) const
{
  return put_mmg3d_metric (out);
}
istream&
field::get_mmg3d_metric (istream& in)
{
   fatal_macro ("input mmg3d metric: not yet");
   return in;
}
