%option noyywrap
%{
// This file is part of Rheolef.
//
// Copyright (C) 2000-2009 Pierre Saramito 
//
// Rheolef is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Rheolef is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Rheolef; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// lexer for qmg mesh files
// =========================================================================
//
// author: Pierre.Saramito@imag.fr
//
// date: 14 february 2002
//
%}
EXP	([eE]([\-+])?([0-9]+))

%%
[\n]     { /* newline */ ++qmg_line_no; }
[ \t]    { /* space  */; }
"("      { return '('; }
")"      { return ')'; }
([\-])?[0-9]+"."[0-9]*{EXP}? |
([\-])?[0-9]*"."[0-9]+{EXP}? |
([\-])?[0-9]+{EXP}      { yylval.float_value = atof(yytext); return FLOAT_NUMBER; }
([\-])?[0-9]+            { yylval.int_value   = atoi(yytext); return INT_NUMBER; }
"mesh_v2.01"([ \t]+)"2"([ \t]+)"2"		{ return MESH2D; }
"mesh_v2.01"([ \t]+)"3"([ \t]+)"3"		{ return MESH3D; }
"VolumeDomainNames"	{ yylval.int_value = 3; return VOLUME_DOMAIN_NAMES; }
"FaceDomainNames"	{ yylval.int_value = 2; return FACE_DOMAIN_NAMES; }
"EdgeDomainNames"	{ yylval.int_value = 1; return EDGE_DOMAIN_NAMES; }
"VertexDomainNames"	{ yylval.int_value = 0; return VERTEX_DOMAIN_NAMES; }
[a-zA-Z][a-zA-Z0-9\-_\.]* {
           yylval.string_value = yytext;
	   return IDENTIFIER;
	 }
"#".*    { /* comment */; }
.        { return *yytext ;  /* default */ }
%%
