///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// field::const_iterator checks
#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t N;
Float f (const point& x) { return 1+(0.5/N)*(x[0]*(1-x[0])+x[1]*(1-x[1])+x[2]*(1-x[2])); }
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  geo omega (argv[1]);
  Float prec = (argc > 2) ? atof(argv[2]) : 1e-10;
  space Vh (omega, "P1");
  N = omega.dimension();
  field fh = interpolate(Vh, f);
  Float sum = 0;
  for (field::const_iterator iter = fh.begin_dof(), last = fh.end_dof(); iter != last; iter++) {
      sum += sqr(*iter);
  }
#ifndef _RHEOLEF_HAVE_MPI
  dout << "euclidian_norm(fh) = " << sqrt(sum) << endl;
#else // _RHEOLEF_HAVE_MPI
  Float dis_sum = mpi::all_reduce (fh.comm(), sum, std::plus<Float>());
  dout << "euclidian_norm(fh) = " << sqrt(dis_sum) << endl;
#endif // _RHEOLEF_HAVE_MPI
}
