#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
#
#usage:
#  run_latex2html srcdir LATEX2HTML TEXEXPAND input.tex L2H_FLAGS...
#
#
srcdir=$1
shift
LATEX2HTML=$1
shift
TEXEXPAND=$1
shift
tex_file=$1
shift
L2H_FLAGS=$*

echo "RUN_LATEX2HTML:"
echo "SRCDIR = " $srcdir
echo "LATEX2HTML = " $LATEX2HTML
echo "TEXEXPAND = " $TEXEXPAND
echo "TEX_FILE = " $tex_file
echo "L2H_FLAGS = " $L2H_FLAGS
echo

echo "run_latex2html" $srcdir $LATEX2HTML $TEXEXPAND $tex_file $L2H_FLAGS

string=`expr ${tex_file} : '\(.*\).tex' \| ${tex_file}`
name=`expr ${string} : '.*/\(.*\)' \| ${string}`
echo NAME $name
# exit 0

/bin/rm -rf ./${name}
builddir=`pwd`
if test x"${srcdir}" != x"."; then
    echo "cd $srcdir"
    cd $srcdir
    full_srcdir=`pwd`
    TEXINPUTS=".:"${builddir}"//:"${full_srcdir}":"${TEXINPUTS}
    export TEXINPUTS
    echo TEXINPUTS $TEXINPUTS
    /bin/rm -rf ./${name}
fi
if test ! -f ${name}.tex; then
    echo "$0: ${srcdir}/${name}.tex: file not found." >&2
    exit 1
fi

cat > latex2html-init << EOF
\$TEXEXPAND = "/bin/sh ${srcdir}/texexpand.sh \$TEXEXPAND \$PERL"
EOF

echo "${LATEX2HTML} -init_file latex2html-init ${L2H_FLAGS} ${name}.tex"

${LATEX2HTML} -init_file latex2html-init ${L2H_FLAGS} ${name}.tex 2>&1 \
    | tee ${builddir}/${name}.hlog

/bin/rm -f latex2html-init

if test -f ./${name}/index.html; then
    status=0
    if test x"${srcdir}" != x"."; then
        /bin/mv -f ./${name} ${builddir}/${name} 2>/dev/null
	status=$?
	if test $status -ne 0; then
	    # perhaps move accross file system: different disks ?
	    /bin/cp -r ./${name} ${builddir}/${name} && /bin/rm -tf ./${name} ${builddir}/${name} 
        fi
    fi
else
    status=1
    /bin/rm -rf ./${name}
fi
exit $status

