/*
*  RAL -- Rubrica Addressbook Library
*  file: csv.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_CSV_H
#define _R_CSV_H

#include <stdio.h>
#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

#include "../../abook.h"
#include "../../error.h"
#include "../../plugin.h"

#define R_CSV_TYPE            (r_csv_get_type())

#define R_CSV(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),  \
                               R_CSV_TYPE, RCsv))

#define R_CSV_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),   \
                               R_CSV_TYPE, RCsvClass))

#define IS_R_CSV(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), R_CSV_TYPE))

#define IS_R_CSV_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  R_CSV_TYPE))

#define R_CSV_GET_CLASS(obj)  (G_TYPE_CHECK_INSTANCE_GET_CLASS((obj), \
                               R_CSV_TYPE, RCsvClass))


typedef struct _RCsv          RCsv;
typedef struct _RCsvClass     RCsvClass;
typedef struct _RCsvPrivate   RCsvPrivate;


struct _RCsv 
{
  RAbook parent;
  
  FILE* fp;                       /* the csv file */

  /* private */
  RCsvPrivate* private;
};


struct _RCsvClass
{
  RAbookClass parent;
};


GType       r_csv_get_type   (void);


/* ************ Public ************


RCsv* r_csv_new                  (void);
void  r_csv_free                 (RCsv *csv);
*/

G_MODULE_EXPORT void plugin_init (RPlugin* plugin, gchar* file);
G_MODULE_EXPORT void plugin_fini (void);

#endif  /* _R_CSV_H */ 
