/* Public domain. */

#include <sys/wait.h>
#include "djbunix.h"

int waitn (int const *pids, register unsigned int n)
{
  register unsigned int len = n ;
  while (len--)
  {
    int wstat ;
    register int pid = wait(&wstat) ;
    if (pid == -1) return -1 ;
    {
      register unsigned int i = 0 ;
      for (; i < n ; i++)
        if (pid == pids[i]) break ;
      if (i >= n) len++ ;
    }
  }
  return 0 ;
}
