/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_EDITCONFLICTPARAM_H
#define _SC_EDITCONFLICTPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/ClientTypes.h"
#include "svn/WcStatusTypes.h"


/**
 * Parameter class for EditConflictCmd.
 */
class EditConflictParam : public ScParam
{
public:
  EditConflictParam( svn::WcStatusPtr status )
    : _status(status)
  {
  }

  svn::WcStatusPtr getStatus() const
  {
    return _status;
  }

  ScParamAccept(EditConflictParam);

private:
  // in
  svn::WcStatusPtr _status;
};

#endif // _SC_EDITCONFLICT_H
