/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGCMD_H
#define _SC_LOGCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class LogParam;


/**
 * Command for retrieving revision log information.
 */
class LogCmd : public ScCmd
{
public:
  /**
   * Construct a LogCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  LogCmd( LogParam* param, CmdResultCallback* cb );
  ~LogCmd();

  void run();

private:
  // in
  LogParam*          _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_LOGCMD_H
