/* Copyright (C) 2014 Stephan Platz <trojita@paalsteek.de>
   Copyright (C) 2014 Jan Kundrát <jkt@kde.org>

   This file is part of the Trojita Qt IMAP e-mail client,
   http://trojita.flaska.net/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License or (at your option) version 3 or any later version
   accepted by the membership of KDE e.V. (or its successor approved
   by the membership of KDE e.V.), which shall act as a proxy
   defined in Section 14 of version 3 of the license.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef TEST_IMAP_MSGPARTNETACCESSMANAGER
#define TEST_IMAP_MSGPARTNETACCESSMANAGER

#include "Imap/Model/DummyNetworkWatcher.h"
#include "Imap/Network/MsgPartNetAccessManager.h"
#include "Utils/LibMailboxSync.h"
#include <QtCore/QObject>

/** @short Unit tests for Imap::Network::MsgPartNetAccessManager and friends */
class ImapMsgPartNetAccessManagerTest : public LibMailboxSync
{
    Q_OBJECT
private Q_SLOTS:
    void init();
    void cleanup();
    void testMessageParts();
    void testMessageParts_data();
    void testFetchResultOfflineSingle();

private:
    Imap::Mailbox::DummyNetworkWatcher *networkPolicy;
    Imap::Network::MsgPartNetAccessManager *netAccessManager;
    QPersistentModelIndex msg1, msg2;
};

#endif /*TEST_IMAP_MSGPARTNETACCESSMANAGER*/
