/*****************************************************************************
 *                                                                           *
 *          UNURAN -- Universal Non-Uniform Random number generator          *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 *   FILE:      rou_rectangle_source.c                                       *
 *                                                                           *
 *                                                                           *
 *   DESCRIPTION:                                                            *
 *      Structure needed for the bounding rectangle calculations used in     *
 *      the multivariate RoU-methods.                                        *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 *   Copyright (c) 2000-2006 Wolfgang Hoermann and Josef Leydold             *
 *   Department of Statistics and Mathematics, WU Wien, Austria              *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by    *
 *   the Free Software Foundation; either version 2 of the License, or       *
 *   (at your option) any later version.                                     *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU General Public License for more details.                            *
 *                                                                           *
 *   You should have received a copy of the GNU General Public License       *
 *   along with this program; if not, write to the                           *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA                  *
 *                                                                           *
 *****************************************************************************/

struct MROU_RECTANGLE {
  UNUR_DISTR *distr;        /* distribution object                           */
  int    dim;               /* dimension of distribution                     */
  double r;	            /* r-parameter of the mrou method 	             */
  int bounding_rectangle;   /* flag to calculate bounding rectangle / strip  */
  double *umin, *umax;      /* boundary rectangle u-coordinates              */
  double vmax;              /* boundary rectangle v-coordinate               */
  const double *center;     /* center of distribution                        */
  int aux_dim;              /* parameter used in auxiliary functions         */
  const char *genid;        /* generator id */
};

/*---------------------------------------------------------------------------*/
