// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_4_5_autogen.cpp:
//   Defines the GL 4.5 entry points.

#include "libGL/entry_points_gl_4_5_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL45_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BindTextureUnit(GLuint unit, GLuint texture)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindTextureUnit", "context = %d, GLuint unit = %u, GLuint texture = %u", CID(context),
          unit, texture);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindTextureUnit(context, unit, texturePacked));
        if (isCallValid)
        {
            context->bindTextureUnit(unit, texturePacked);
        }
        ANGLE_CAPTURE(BindTextureUnit, isCallValid, context, unit, texturePacked);
    }
}

void GL_APIENTRY BlitNamedFramebuffer(GLuint readFramebuffer,
                                      GLuint drawFramebuffer,
                                      GLint srcX0,
                                      GLint srcY0,
                                      GLint srcX1,
                                      GLint srcY1,
                                      GLint dstX0,
                                      GLint dstY0,
                                      GLint dstX1,
                                      GLint dstY1,
                                      GLbitfield mask,
                                      GLenum filter)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBlitNamedFramebuffer",
          "context = %d, GLuint readFramebuffer = %u, GLuint drawFramebuffer = %u, GLint srcX0 = "
          "%d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, GLint dstX0 = %d, GLint dstY0 "
          "= %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask = %s, GLenum filter = %s",
          CID(context), readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0,
          dstX1, dstY1, GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlitNamedFramebuffer(context, readFramebuffer, drawFramebuffer, srcX0, srcY0,
                                          srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitNamedFramebuffer(readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1,
                                          srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        }
        ANGLE_CAPTURE(BlitNamedFramebuffer, isCallValid, context, readFramebuffer, drawFramebuffer,
                      srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
}

GLenum GL_APIENTRY CheckNamedFramebufferStatus(GLuint framebuffer, GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCheckNamedFramebufferStatus",
          "context = %d, GLuint framebuffer = %u, GLenum target = %s", CID(context), framebuffer,
          GLenumToString(GLenumGroup::FramebufferTarget, target));

    GLenum returnValue;
    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCheckNamedFramebufferStatus(
                                                             context, framebufferPacked, target));
        if (isCallValid)
        {
            returnValue = context->checkNamedFramebufferStatus(framebufferPacked, target);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CheckNamedFramebufferStatus, GLenum>();
        }
        ANGLE_CAPTURE(CheckNamedFramebufferStatus, isCallValid, context, framebufferPacked, target,
                      returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::CheckNamedFramebufferStatus, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY ClearNamedBufferData(GLuint buffer,
                                      GLenum internalformat,
                                      GLenum format,
                                      GLenum type,
                                      const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClearNamedBufferData",
          "context = %d, GLuint buffer = %u, GLenum internalformat = %s, GLenum format = %s, "
          "GLenum type = %s, const void *data = 0x%016" PRIxPTR "",
          CID(context), buffer, GLenumToString(GLenumGroup::InternalFormat, internalformat),
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)data);

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearNamedBufferData(context, bufferPacked, internalformat,
                                                         format, type, data));
        if (isCallValid)
        {
            context->clearNamedBufferData(bufferPacked, internalformat, format, type, data);
        }
        ANGLE_CAPTURE(ClearNamedBufferData, isCallValid, context, bufferPacked, internalformat,
                      format, type, data);
    }
}

void GL_APIENTRY ClearNamedBufferSubData(GLuint buffer,
                                         GLenum internalformat,
                                         GLintptr offset,
                                         GLsizeiptr size,
                                         GLenum format,
                                         GLenum type,
                                         const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClearNamedBufferSubData",
          "context = %d, GLuint buffer = %u, GLenum internalformat = %s, GLintptr offset = %llu, "
          "GLsizeiptr size = %llu, GLenum format = %s, GLenum type = %s, const void *data = "
          "0x%016" PRIxPTR "",
          CID(context), buffer, GLenumToString(GLenumGroup::InternalFormat, internalformat),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)data);

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearNamedBufferSubData(context, bufferPacked, internalformat,
                                                            offset, size, format, type, data));
        if (isCallValid)
        {
            context->clearNamedBufferSubData(bufferPacked, internalformat, offset, size, format,
                                             type, data);
        }
        ANGLE_CAPTURE(ClearNamedBufferSubData, isCallValid, context, bufferPacked, internalformat,
                      offset, size, format, type, data);
    }
}

void GL_APIENTRY ClearNamedFramebufferfi(GLuint framebuffer,
                                         GLenum buffer,
                                         GLint drawbuffer,
                                         GLfloat depth,
                                         GLint stencil)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClearNamedFramebufferfi",
          "context = %d, GLuint framebuffer = %u, GLenum buffer = %s, GLint drawbuffer = %d, "
          "GLfloat depth = %f, GLint stencil = %d",
          CID(context), framebuffer, GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, depth,
          stencil);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearNamedFramebufferfi(context, framebufferPacked, buffer,
                                                            drawbuffer, depth, stencil));
        if (isCallValid)
        {
            context->clearNamedFramebufferfi(framebufferPacked, buffer, drawbuffer, depth, stencil);
        }
        ANGLE_CAPTURE(ClearNamedFramebufferfi, isCallValid, context, framebufferPacked, buffer,
                      drawbuffer, depth, stencil);
    }
}

void GL_APIENTRY ClearNamedFramebufferfv(GLuint framebuffer,
                                         GLenum buffer,
                                         GLint drawbuffer,
                                         const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClearNamedFramebufferfv",
          "context = %d, GLuint framebuffer = %u, GLenum buffer = %s, GLint drawbuffer = %d, const "
          "GLfloat *value = 0x%016" PRIxPTR "",
          CID(context), framebuffer, GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer,
          (uintptr_t)value);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearNamedFramebufferfv(context, framebufferPacked, buffer,
                                                            drawbuffer, value));
        if (isCallValid)
        {
            context->clearNamedFramebufferfv(framebufferPacked, buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearNamedFramebufferfv, isCallValid, context, framebufferPacked, buffer,
                      drawbuffer, value);
    }
}

void GL_APIENTRY ClearNamedFramebufferiv(GLuint framebuffer,
                                         GLenum buffer,
                                         GLint drawbuffer,
                                         const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClearNamedFramebufferiv",
          "context = %d, GLuint framebuffer = %u, GLenum buffer = %s, GLint drawbuffer = %d, const "
          "GLint *value = 0x%016" PRIxPTR "",
          CID(context), framebuffer, GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer,
          (uintptr_t)value);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearNamedFramebufferiv(context, framebufferPacked, buffer,
                                                            drawbuffer, value));
        if (isCallValid)
        {
            context->clearNamedFramebufferiv(framebufferPacked, buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearNamedFramebufferiv, isCallValid, context, framebufferPacked, buffer,
                      drawbuffer, value);
    }
}

void GL_APIENTRY ClearNamedFramebufferuiv(GLuint framebuffer,
                                          GLenum buffer,
                                          GLint drawbuffer,
                                          const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClearNamedFramebufferuiv",
          "context = %d, GLuint framebuffer = %u, GLenum buffer = %s, GLint drawbuffer = %d, const "
          "GLuint *value = 0x%016" PRIxPTR "",
          CID(context), framebuffer, GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer,
          (uintptr_t)value);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateClearNamedFramebufferuiv(context, framebufferPacked, buffer,
                                                             drawbuffer, value));
        if (isCallValid)
        {
            context->clearNamedFramebufferuiv(framebufferPacked, buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearNamedFramebufferuiv, isCallValid, context, framebufferPacked, buffer,
                      drawbuffer, value);
    }
}

void GL_APIENTRY ClipControl(GLenum origin, GLenum depth)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClipControl", "context = %d, GLenum origin = %s, GLenum depth = %s", CID(context),
          GLenumToString(GLenumGroup::ClipControlOrigin, origin),
          GLenumToString(GLenumGroup::ClipControlDepth, depth));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClipControl(context, origin, depth));
        if (isCallValid)
        {
            context->clipControl(origin, depth);
        }
        ANGLE_CAPTURE(ClipControl, isCallValid, context, origin, depth);
    }
}

void GL_APIENTRY CompressedTextureSubImage1D(GLuint texture,
                                             GLint level,
                                             GLint xoffset,
                                             GLsizei width,
                                             GLenum format,
                                             GLsizei imageSize,
                                             const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTextureSubImage1D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLsizei width "
          "= %d, GLenum format = %s, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, width,
          GLenumToString(GLenumGroup::PixelFormat, format), imageSize, (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCompressedTextureSubImage1D(
                                                             context, texturePacked, level, xoffset,
                                                             width, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTextureSubImage1D(texturePacked, level, xoffset, width, format,
                                                 imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTextureSubImage1D, isCallValid, context, texturePacked, level,
                      xoffset, width, format, imageSize, data);
    }
}

void GL_APIENTRY CompressedTextureSubImage2D(GLuint texture,
                                             GLint level,
                                             GLint xoffset,
                                             GLint yoffset,
                                             GLsizei width,
                                             GLsizei height,
                                             GLenum format,
                                             GLsizei imageSize,
                                             const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTextureSubImage2D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset "
          "= %d, GLsizei width = %d, GLsizei height = %d, GLenum format = %s, GLsizei imageSize = "
          "%d, const void *data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, width, height,
          GLenumToString(GLenumGroup::PixelFormat, format), imageSize, (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTextureSubImage2D(context, texturePacked, level, xoffset, yoffset,
                                                 width, height, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTextureSubImage2D(texturePacked, level, xoffset, yoffset, width,
                                                 height, format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTextureSubImage2D, isCallValid, context, texturePacked, level,
                      xoffset, yoffset, width, height, format, imageSize, data);
    }
}

void GL_APIENTRY CompressedTextureSubImage3D(GLuint texture,
                                             GLint level,
                                             GLint xoffset,
                                             GLint yoffset,
                                             GLint zoffset,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             GLenum format,
                                             GLsizei imageSize,
                                             const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCompressedTextureSubImage3D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset "
          "= %d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
          GLenumToString(GLenumGroup::PixelFormat, format), imageSize, (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCompressedTextureSubImage3D(
                                context, texturePacked, level, xoffset, yoffset, zoffset, width,
                                height, depth, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTextureSubImage3D(texturePacked, level, xoffset, yoffset, zoffset,
                                                 width, height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTextureSubImage3D, isCallValid, context, texturePacked, level,
                      xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
}

void GL_APIENTRY CopyNamedBufferSubData(GLuint readBuffer,
                                        GLuint writeBuffer,
                                        GLintptr readOffset,
                                        GLintptr writeOffset,
                                        GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopyNamedBufferSubData",
          "context = %d, GLuint readBuffer = %u, GLuint writeBuffer = %u, GLintptr readOffset = "
          "%llu, GLintptr writeOffset = %llu, GLsizeiptr size = %llu",
          CID(context), readBuffer, writeBuffer, static_cast<unsigned long long>(readOffset),
          static_cast<unsigned long long>(writeOffset), static_cast<unsigned long long>(size));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyNamedBufferSubData(context, readBuffer, writeBuffer,
                                                           readOffset, writeOffset, size));
        if (isCallValid)
        {
            context->copyNamedBufferSubData(readBuffer, writeBuffer, readOffset, writeOffset, size);
        }
        ANGLE_CAPTURE(CopyNamedBufferSubData, isCallValid, context, readBuffer, writeBuffer,
                      readOffset, writeOffset, size);
    }
}

void GL_APIENTRY
CopyTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopyTextureSubImage1D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint x = %d, "
          "GLint y = %d, GLsizei width = %d",
          CID(context), texture, level, xoffset, x, y, width);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyTextureSubImage1D(context, texturePacked, level, xoffset, x, y, width));
        if (isCallValid)
        {
            context->copyTextureSubImage1D(texturePacked, level, xoffset, x, y, width);
        }
        ANGLE_CAPTURE(CopyTextureSubImage1D, isCallValid, context, texturePacked, level, xoffset, x,
                      y, width);
    }
}

void GL_APIENTRY CopyTextureSubImage2D(GLuint texture,
                                       GLint level,
                                       GLint xoffset,
                                       GLint yoffset,
                                       GLint x,
                                       GLint y,
                                       GLsizei width,
                                       GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopyTextureSubImage2D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset "
          "= %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d",
          CID(context), texture, level, xoffset, yoffset, x, y, width, height);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTextureSubImage2D(context, texturePacked, level, xoffset,
                                                          yoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTextureSubImage2D(texturePacked, level, xoffset, yoffset, x, y, width,
                                           height);
        }
        ANGLE_CAPTURE(CopyTextureSubImage2D, isCallValid, context, texturePacked, level, xoffset,
                      yoffset, x, y, width, height);
    }
}

void GL_APIENTRY CopyTextureSubImage3D(GLuint texture,
                                       GLint level,
                                       GLint xoffset,
                                       GLint yoffset,
                                       GLint zoffset,
                                       GLint x,
                                       GLint y,
                                       GLsizei width,
                                       GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCopyTextureSubImage3D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset "
          "= %d, GLint zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei "
          "height = %d",
          CID(context), texture, level, xoffset, yoffset, zoffset, x, y, width, height);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCopyTextureSubImage3D(context, texturePacked, level, xoffset,
                                                          yoffset, zoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTextureSubImage3D(texturePacked, level, xoffset, yoffset, zoffset, x, y,
                                           width, height);
        }
        ANGLE_CAPTURE(CopyTextureSubImage3D, isCallValid, context, texturePacked, level, xoffset,
                      yoffset, zoffset, x, y, width, height);
    }
}

void GL_APIENTRY CreateBuffers(GLsizei n, GLuint *buffers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateBuffers", "context = %d, GLsizei n = %d, GLuint *buffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)buffers);

    if (context)
    {
        BufferID *buffersPacked                       = FromGL<BufferID *>(buffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCreateBuffers(context, n, buffersPacked));
        if (isCallValid)
        {
            context->createBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE(CreateBuffers, isCallValid, context, n, buffersPacked);
    }
}

void GL_APIENTRY CreateFramebuffers(GLsizei n, GLuint *framebuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateFramebuffers",
          "context = %d, GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCreateFramebuffers(context, n, framebuffers));
        if (isCallValid)
        {
            context->createFramebuffers(n, framebuffers);
        }
        ANGLE_CAPTURE(CreateFramebuffers, isCallValid, context, n, framebuffers);
    }
}

void GL_APIENTRY CreateProgramPipelines(GLsizei n, GLuint *pipelines)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateProgramPipelines",
          "context = %d, GLsizei n = %d, GLuint *pipelines = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)pipelines);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCreateProgramPipelines(context, n, pipelines));
        if (isCallValid)
        {
            context->createProgramPipelines(n, pipelines);
        }
        ANGLE_CAPTURE(CreateProgramPipelines, isCallValid, context, n, pipelines);
    }
}

void GL_APIENTRY CreateQueries(GLenum target, GLsizei n, GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateQueries",
          "context = %d, GLenum target = %s, GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::QueryTarget, target), n, (uintptr_t)ids);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCreateQueries(context, target, n, ids));
        if (isCallValid)
        {
            context->createQueries(target, n, ids);
        }
        ANGLE_CAPTURE(CreateQueries, isCallValid, context, target, n, ids);
    }
}

void GL_APIENTRY CreateRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateRenderbuffers",
          "context = %d, GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)renderbuffers);

    if (context)
    {
        RenderbufferID *renderbuffersPacked           = FromGL<RenderbufferID *>(renderbuffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateCreateRenderbuffers(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->createRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(CreateRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
}

void GL_APIENTRY CreateSamplers(GLsizei n, GLuint *samplers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateSamplers", "context = %d, GLsizei n = %d, GLuint *samplers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)samplers);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCreateSamplers(context, n, samplers));
        if (isCallValid)
        {
            context->createSamplers(n, samplers);
        }
        ANGLE_CAPTURE(CreateSamplers, isCallValid, context, n, samplers);
    }
}

void GL_APIENTRY CreateTextures(GLenum target, GLsizei n, GLuint *textures)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateTextures",
          "context = %d, GLenum target = %s, GLsizei n = %d, GLuint *textures = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), n, (uintptr_t)textures);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCreateTextures(context, target, n, textures));
        if (isCallValid)
        {
            context->createTextures(target, n, textures);
        }
        ANGLE_CAPTURE(CreateTextures, isCallValid, context, target, n, textures);
    }
}

void GL_APIENTRY CreateTransformFeedbacks(GLsizei n, GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateTransformFeedbacks",
          "context = %d, GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)ids);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCreateTransformFeedbacks(context, n, ids));
        if (isCallValid)
        {
            context->createTransformFeedbacks(n, ids);
        }
        ANGLE_CAPTURE(CreateTransformFeedbacks, isCallValid, context, n, ids);
    }
}

void GL_APIENTRY CreateVertexArrays(GLsizei n, GLuint *arrays)
{
    Context *context = GetValidGlobalContext();
    EVENT("glCreateVertexArrays",
          "context = %d, GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)arrays);

    if (context)
    {
        VertexArrayID *arraysPacked                   = FromGL<VertexArrayID *>(arrays);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCreateVertexArrays(context, n, arraysPacked));
        if (isCallValid)
        {
            context->createVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(CreateVertexArrays, isCallValid, context, n, arraysPacked);
    }
}

void GL_APIENTRY DisableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT("glDisableVertexArrayAttrib", "context = %d, GLuint vaobj = %u, GLuint index = %u",
          CID(context), vaobj, index);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateDisableVertexArrayAttrib(context, vaobjPacked, index));
        if (isCallValid)
        {
            context->disableVertexArrayAttrib(vaobjPacked, index);
        }
        ANGLE_CAPTURE(DisableVertexArrayAttrib, isCallValid, context, vaobjPacked, index);
    }
}

void GL_APIENTRY EnableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT("glEnableVertexArrayAttrib", "context = %d, GLuint vaobj = %u, GLuint index = %u",
          CID(context), vaobj, index);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateEnableVertexArrayAttrib(context, vaobjPacked, index));
        if (isCallValid)
        {
            context->enableVertexArrayAttrib(vaobjPacked, index);
        }
        ANGLE_CAPTURE(EnableVertexArrayAttrib, isCallValid, context, vaobjPacked, index);
    }
}

void GL_APIENTRY FlushMappedNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
    Context *context = GetValidGlobalContext();
    EVENT("glFlushMappedNamedBufferRange",
          "context = %d, GLuint buffer = %u, GLintptr offset = %llu, GLsizeiptr length = %llu",
          CID(context), buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(length));

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFlushMappedNamedBufferRange(context, bufferPacked, offset, length));
        if (isCallValid)
        {
            context->flushMappedNamedBufferRange(bufferPacked, offset, length);
        }
        ANGLE_CAPTURE(FlushMappedNamedBufferRange, isCallValid, context, bufferPacked, offset,
                      length);
    }
}

void GL_APIENTRY GenerateTextureMipmap(GLuint texture)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGenerateTextureMipmap", "context = %d, GLuint texture = %u", CID(context), texture);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenerateTextureMipmap(context, texturePacked));
        if (isCallValid)
        {
            context->generateTextureMipmap(texturePacked);
        }
        ANGLE_CAPTURE(GenerateTextureMipmap, isCallValid, context, texturePacked);
    }
}

void GL_APIENTRY GetCompressedTextureImage(GLuint texture,
                                           GLint level,
                                           GLsizei bufSize,
                                           void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetCompressedTextureImage",
          "context = %d, GLuint texture = %u, GLint level = %d, GLsizei bufSize = %d, void *pixels "
          "= 0x%016" PRIxPTR "",
          CID(context), texture, level, bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetCompressedTextureImage(context, texturePacked, level, bufSize, pixels));
        if (isCallValid)
        {
            context->getCompressedTextureImage(texturePacked, level, bufSize, pixels);
        }
        ANGLE_CAPTURE(GetCompressedTextureImage, isCallValid, context, texturePacked, level,
                      bufSize, pixels);
    }
}

void GL_APIENTRY GetCompressedTextureSubImage(GLuint texture,
                                              GLint level,
                                              GLint xoffset,
                                              GLint yoffset,
                                              GLint zoffset,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLsizei bufSize,
                                              void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetCompressedTextureSubImage",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset "
          "= %d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLsizei bufSize = %d, void *pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize,
          (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetCompressedTextureSubImage(context, texturePacked, level, xoffset, yoffset,
                                                  zoffset, width, height, depth, bufSize, pixels));
        if (isCallValid)
        {
            context->getCompressedTextureSubImage(texturePacked, level, xoffset, yoffset, zoffset,
                                                  width, height, depth, bufSize, pixels);
        }
        ANGLE_CAPTURE(GetCompressedTextureSubImage, isCallValid, context, texturePacked, level,
                      xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels);
    }
}

GLenum GL_APIENTRY GetGraphicsResetStatus()
{
    Context *context = GetGlobalContext();
    EVENT("glGetGraphicsResetStatus", "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetGraphicsResetStatus(context));
        if (isCallValid)
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatus, GLenum>();
        }
        ANGLE_CAPTURE(GetGraphicsResetStatus, isCallValid, context, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatus, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GetNamedBufferParameteri64v(GLuint buffer, GLenum pname, GLint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetNamedBufferParameteri64v",
          "context = %d, GLuint buffer = %u, GLenum pname = %s, GLint64 *params = 0x%016" PRIxPTR
          "",
          CID(context), buffer, GLenumToString(GLenumGroup::VertexBufferObjectParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetNamedBufferParameteri64v(
                                                             context, bufferPacked, pname, params));
        if (isCallValid)
        {
            context->getNamedBufferParameteri64v(bufferPacked, pname, params);
        }
        ANGLE_CAPTURE(GetNamedBufferParameteri64v, isCallValid, context, bufferPacked, pname,
                      params);
    }
}

void GL_APIENTRY GetNamedBufferParameteriv(GLuint buffer, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetNamedBufferParameteriv",
          "context = %d, GLuint buffer = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), buffer, GLenumToString(GLenumGroup::VertexBufferObjectParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetNamedBufferParameteriv(
                                                             context, bufferPacked, pname, params));
        if (isCallValid)
        {
            context->getNamedBufferParameteriv(bufferPacked, pname, params);
        }
        ANGLE_CAPTURE(GetNamedBufferParameteriv, isCallValid, context, bufferPacked, pname, params);
    }
}

void GL_APIENTRY GetNamedBufferPointerv(GLuint buffer, GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetNamedBufferPointerv",
          "context = %d, GLuint buffer = %u, GLenum pname = %s, void **params = 0x%016" PRIxPTR "",
          CID(context), buffer, GLenumToString(GLenumGroup::VertexBufferObjectParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetNamedBufferPointerv(context, bufferPacked, pname, params));
        if (isCallValid)
        {
            context->getNamedBufferPointerv(bufferPacked, pname, params);
        }
        ANGLE_CAPTURE(GetNamedBufferPointerv, isCallValid, context, bufferPacked, pname, params);
    }
}

void GL_APIENTRY GetNamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetNamedBufferSubData",
          "context = %d, GLuint buffer = %u, GLintptr offset = %llu, GLsizeiptr size = %llu, void "
          "*data = 0x%016" PRIxPTR "",
          CID(context), buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(size), (uintptr_t)data);

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetNamedBufferSubData(context, bufferPacked, offset, size, data));
        if (isCallValid)
        {
            context->getNamedBufferSubData(bufferPacked, offset, size, data);
        }
        ANGLE_CAPTURE(GetNamedBufferSubData, isCallValid, context, bufferPacked, offset, size,
                      data);
    }
}

void GL_APIENTRY GetNamedFramebufferAttachmentParameteriv(GLuint framebuffer,
                                                          GLenum attachment,
                                                          GLenum pname,
                                                          GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetNamedFramebufferAttachmentParameteriv",
          "context = %d, GLuint framebuffer = %u, GLenum attachment = %s, GLenum pname = %s, GLint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), framebuffer, GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetNamedFramebufferAttachmentParameteriv(
                                context, framebufferPacked, attachment, pname, params));
        if (isCallValid)
        {
            context->getNamedFramebufferAttachmentParameteriv(framebufferPacked, attachment, pname,
                                                              params);
        }
        ANGLE_CAPTURE(GetNamedFramebufferAttachmentParameteriv, isCallValid, context,
                      framebufferPacked, attachment, pname, params);
    }
}

void GL_APIENTRY GetNamedFramebufferParameteriv(GLuint framebuffer, GLenum pname, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetNamedFramebufferParameteriv",
          "context = %d, GLuint framebuffer = %u, GLenum pname = %s, GLint *param = 0x%016" PRIxPTR
          "",
          CID(context), framebuffer, GLenumToString(GLenumGroup::GetFramebufferParameter, pname),
          (uintptr_t)param);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetNamedFramebufferParameteriv(context, framebufferPacked, pname, param));
        if (isCallValid)
        {
            context->getNamedFramebufferParameteriv(framebufferPacked, pname, param);
        }
        ANGLE_CAPTURE(GetNamedFramebufferParameteriv, isCallValid, context, framebufferPacked,
                      pname, param);
    }
}

void GL_APIENTRY GetNamedRenderbufferParameteriv(GLuint renderbuffer, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glGetNamedRenderbufferParameteriv",
        "context = %d, GLuint renderbuffer = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), renderbuffer, GLenumToString(GLenumGroup::RenderbufferParameterName, pname),
        (uintptr_t)params);

    if (context)
    {
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetNamedRenderbufferParameteriv(context, renderbufferPacked, pname, params));
        if (isCallValid)
        {
            context->getNamedRenderbufferParameteriv(renderbufferPacked, pname, params);
        }
        ANGLE_CAPTURE(GetNamedRenderbufferParameteriv, isCallValid, context, renderbufferPacked,
                      pname, params);
    }
}

void GL_APIENTRY GetQueryBufferObjecti64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryBufferObjecti64v",
          "context = %d, GLuint id = %u, GLuint buffer = %u, GLenum pname = %s, GLintptr offset = "
          "%llu",
          CID(context), id, buffer, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          static_cast<unsigned long long>(offset));

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryBufferObjecti64v(context, id, bufferPacked, pname, offset));
        if (isCallValid)
        {
            context->getQueryBufferObjecti64v(id, bufferPacked, pname, offset);
        }
        ANGLE_CAPTURE(GetQueryBufferObjecti64v, isCallValid, context, id, bufferPacked, pname,
                      offset);
    }
}

void GL_APIENTRY GetQueryBufferObjectiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryBufferObjectiv",
          "context = %d, GLuint id = %u, GLuint buffer = %u, GLenum pname = %s, GLintptr offset = "
          "%llu",
          CID(context), id, buffer, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          static_cast<unsigned long long>(offset));

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryBufferObjectiv(context, id, bufferPacked, pname, offset));
        if (isCallValid)
        {
            context->getQueryBufferObjectiv(id, bufferPacked, pname, offset);
        }
        ANGLE_CAPTURE(GetQueryBufferObjectiv, isCallValid, context, id, bufferPacked, pname,
                      offset);
    }
}

void GL_APIENTRY GetQueryBufferObjectui64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryBufferObjectui64v",
          "context = %d, GLuint id = %u, GLuint buffer = %u, GLenum pname = %s, GLintptr offset = "
          "%llu",
          CID(context), id, buffer, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          static_cast<unsigned long long>(offset));

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryBufferObjectui64v(context, id, bufferPacked, pname, offset));
        if (isCallValid)
        {
            context->getQueryBufferObjectui64v(id, bufferPacked, pname, offset);
        }
        ANGLE_CAPTURE(GetQueryBufferObjectui64v, isCallValid, context, id, bufferPacked, pname,
                      offset);
    }
}

void GL_APIENTRY GetQueryBufferObjectuiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetQueryBufferObjectuiv",
          "context = %d, GLuint id = %u, GLuint buffer = %u, GLenum pname = %s, GLintptr offset = "
          "%llu",
          CID(context), id, buffer, GLenumToString(GLenumGroup::QueryObjectParameterName, pname),
          static_cast<unsigned long long>(offset));

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryBufferObjectuiv(context, id, bufferPacked, pname, offset));
        if (isCallValid)
        {
            context->getQueryBufferObjectuiv(id, bufferPacked, pname, offset);
        }
        ANGLE_CAPTURE(GetQueryBufferObjectuiv, isCallValid, context, id, bufferPacked, pname,
                      offset);
    }
}

void GL_APIENTRY GetTextureImage(GLuint texture,
                                 GLint level,
                                 GLenum format,
                                 GLenum type,
                                 GLsizei bufSize,
                                 void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTextureImage",
          "context = %d, GLuint texture = %u, GLint level = %d, GLenum format = %s, GLenum type = "
          "%s, GLsizei bufSize = %d, void *pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureImage(context, texturePacked, level, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->getTextureImage(texturePacked, level, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(GetTextureImage, isCallValid, context, texturePacked, level, format, type,
                      bufSize, pixels);
    }
}

void GL_APIENTRY GetTextureLevelParameterfv(GLuint texture,
                                            GLint level,
                                            GLenum pname,
                                            GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTextureLevelParameterfv",
          "context = %d, GLuint texture = %u, GLint level = %d, GLenum pname = %s, GLfloat *params "
          "= 0x%016" PRIxPTR "",
          CID(context), texture, level, GLenumToString(GLenumGroup::GetTextureParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureLevelParameterfv(context, texturePacked, level, pname, params));
        if (isCallValid)
        {
            context->getTextureLevelParameterfv(texturePacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTextureLevelParameterfv, isCallValid, context, texturePacked, level, pname,
                      params);
    }
}

void GL_APIENTRY GetTextureLevelParameteriv(GLuint texture,
                                            GLint level,
                                            GLenum pname,
                                            GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTextureLevelParameteriv",
          "context = %d, GLuint texture = %u, GLint level = %d, GLenum pname = %s, GLint *params = "
          "0x%016" PRIxPTR "",
          CID(context), texture, level, GLenumToString(GLenumGroup::GetTextureParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureLevelParameteriv(context, texturePacked, level, pname, params));
        if (isCallValid)
        {
            context->getTextureLevelParameteriv(texturePacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTextureLevelParameteriv, isCallValid, context, texturePacked, level, pname,
                      params);
    }
}

void GL_APIENTRY GetTextureParameterIiv(GLuint texture, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTextureParameterIiv",
          "context = %d, GLuint texture = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), texture, GLenumToString(GLenumGroup::GetTextureParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTextureParameterIiv(context, texturePacked, pname, params));
        if (isCallValid)
        {
            context->getTextureParameterIiv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE(GetTextureParameterIiv, isCallValid, context, texturePacked, pname, params);
    }
}

void GL_APIENTRY GetTextureParameterIuiv(GLuint texture, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTextureParameterIuiv",
          "context = %d, GLuint texture = %u, GLenum pname = %s, GLuint *params = 0x%016" PRIxPTR
          "",
          CID(context), texture, GLenumToString(GLenumGroup::GetTextureParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTextureParameterIuiv(context, texturePacked, pname, params));
        if (isCallValid)
        {
            context->getTextureParameterIuiv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE(GetTextureParameterIuiv, isCallValid, context, texturePacked, pname, params);
    }
}

void GL_APIENTRY GetTextureParameterfv(GLuint texture, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTextureParameterfv",
          "context = %d, GLuint texture = %u, GLenum pname = %s, GLfloat *params = 0x%016" PRIxPTR
          "",
          CID(context), texture, GLenumToString(GLenumGroup::GetTextureParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTextureParameterfv(context, texturePacked, pname, params));
        if (isCallValid)
        {
            context->getTextureParameterfv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE(GetTextureParameterfv, isCallValid, context, texturePacked, pname, params);
    }
}

void GL_APIENTRY GetTextureParameteriv(GLuint texture, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTextureParameteriv",
          "context = %d, GLuint texture = %u, GLenum pname = %s, GLint *params = 0x%016" PRIxPTR "",
          CID(context), texture, GLenumToString(GLenumGroup::GetTextureParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTextureParameteriv(context, texturePacked, pname, params));
        if (isCallValid)
        {
            context->getTextureParameteriv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE(GetTextureParameteriv, isCallValid, context, texturePacked, pname, params);
    }
}

void GL_APIENTRY GetTextureSubImage(GLuint texture,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint zoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLenum format,
                                    GLenum type,
                                    GLsizei bufSize,
                                    void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glGetTextureSubImage",
        "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset = "
        "%d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
        "GLenum format = %s, GLenum type = %s, GLsizei bufSize = %d, void *pixels = 0x%016" PRIxPTR
        "",
        CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
        GLenumToString(GLenumGroup::PixelFormat, format),
        GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureSubImage(context, texturePacked, level, xoffset, yoffset, zoffset,
                                        width, height, depth, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->getTextureSubImage(texturePacked, level, xoffset, yoffset, zoffset, width,
                                        height, depth, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(GetTextureSubImage, isCallValid, context, texturePacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
    }
}

void GL_APIENTRY GetTransformFeedbacki64_v(GLuint xfb, GLenum pname, GLuint index, GLint64 *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTransformFeedbacki64_v",
          "context = %d, GLuint xfb = %u, GLenum pname = %s, GLuint index = %u, GLint64 *param = "
          "0x%016" PRIxPTR "",
          CID(context), xfb, GLenumToString(GLenumGroup::TransformFeedbackPName, pname), index,
          (uintptr_t)param);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTransformFeedbacki64_v(context, xfb, pname, index, param));
        if (isCallValid)
        {
            context->getTransformFeedbacki64_v(xfb, pname, index, param);
        }
        ANGLE_CAPTURE(GetTransformFeedbacki64_v, isCallValid, context, xfb, pname, index, param);
    }
}

void GL_APIENTRY GetTransformFeedbacki_v(GLuint xfb, GLenum pname, GLuint index, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTransformFeedbacki_v",
          "context = %d, GLuint xfb = %u, GLenum pname = %s, GLuint index = %u, GLint *param = "
          "0x%016" PRIxPTR "",
          CID(context), xfb, GLenumToString(GLenumGroup::TransformFeedbackPName, pname), index,
          (uintptr_t)param);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTransformFeedbacki_v(context, xfb, pname, index, param));
        if (isCallValid)
        {
            context->getTransformFeedbacki_v(xfb, pname, index, param);
        }
        ANGLE_CAPTURE(GetTransformFeedbacki_v, isCallValid, context, xfb, pname, index, param);
    }
}

void GL_APIENTRY GetTransformFeedbackiv(GLuint xfb, GLenum pname, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetTransformFeedbackiv",
          "context = %d, GLuint xfb = %u, GLenum pname = %s, GLint *param = 0x%016" PRIxPTR "",
          CID(context), xfb, GLenumToString(GLenumGroup::TransformFeedbackPName, pname),
          (uintptr_t)param);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetTransformFeedbackiv(context, xfb, pname, param));
        if (isCallValid)
        {
            context->getTransformFeedbackiv(xfb, pname, param);
        }
        ANGLE_CAPTURE(GetTransformFeedbackiv, isCallValid, context, xfb, pname, param);
    }
}

void GL_APIENTRY GetVertexArrayIndexed64iv(GLuint vaobj, GLuint index, GLenum pname, GLint64 *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexArrayIndexed64iv",
          "context = %d, GLuint vaobj = %u, GLuint index = %u, GLenum pname = %s, GLint64 *param = "
          "0x%016" PRIxPTR "",
          CID(context), vaobj, index, GLenumToString(GLenumGroup::VertexArrayPName, pname),
          (uintptr_t)param);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexArrayIndexed64iv(context, vaobjPacked, index, pname, param));
        if (isCallValid)
        {
            context->getVertexArrayIndexed64iv(vaobjPacked, index, pname, param);
        }
        ANGLE_CAPTURE(GetVertexArrayIndexed64iv, isCallValid, context, vaobjPacked, index, pname,
                      param);
    }
}

void GL_APIENTRY GetVertexArrayIndexediv(GLuint vaobj, GLuint index, GLenum pname, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexArrayIndexediv",
          "context = %d, GLuint vaobj = %u, GLuint index = %u, GLenum pname = %s, GLint *param = "
          "0x%016" PRIxPTR "",
          CID(context), vaobj, index, GLenumToString(GLenumGroup::VertexArrayPName, pname),
          (uintptr_t)param);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexArrayIndexediv(context, vaobjPacked, index, pname, param));
        if (isCallValid)
        {
            context->getVertexArrayIndexediv(vaobjPacked, index, pname, param);
        }
        ANGLE_CAPTURE(GetVertexArrayIndexediv, isCallValid, context, vaobjPacked, index, pname,
                      param);
    }
}

void GL_APIENTRY GetVertexArrayiv(GLuint vaobj, GLenum pname, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetVertexArrayiv",
          "context = %d, GLuint vaobj = %u, GLenum pname = %s, GLint *param = 0x%016" PRIxPTR "",
          CID(context), vaobj, GLenumToString(GLenumGroup::VertexArrayPName, pname),
          (uintptr_t)param);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetVertexArrayiv(context, vaobjPacked, pname, param));
        if (isCallValid)
        {
            context->getVertexArrayiv(vaobjPacked, pname, param);
        }
        ANGLE_CAPTURE(GetVertexArrayiv, isCallValid, context, vaobjPacked, pname, param);
    }
}

void GL_APIENTRY
GetnColorTable(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnColorTable",
          "context = %d, GLenum target = %s, GLenum format = %s, GLenum type = %s, GLsizei bufSize "
          "= %d, void *table = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ColorTableTarget, target),
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)table);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetnColorTable(context, target, format, type, bufSize, table));
        if (isCallValid)
        {
            context->getnColorTable(target, format, type, bufSize, table);
        }
        ANGLE_CAPTURE(GetnColorTable, isCallValid, context, target, format, type, bufSize, table);
    }
}

void GL_APIENTRY GetnCompressedTexImage(GLenum target, GLint lod, GLsizei bufSize, void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnCompressedTexImage",
          "context = %d, GLenum target = %s, GLint lod = %d, GLsizei bufSize = %d, void *pixels = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), lod, bufSize,
          (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetnCompressedTexImage(context, target, lod, bufSize, pixels));
        if (isCallValid)
        {
            context->getnCompressedTexImage(target, lod, bufSize, pixels);
        }
        ANGLE_CAPTURE(GetnCompressedTexImage, isCallValid, context, target, lod, bufSize, pixels);
    }
}

void GL_APIENTRY
GetnConvolutionFilter(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnConvolutionFilter",
          "context = %d, GLenum target = %s, GLenum format = %s, GLenum type = %s, GLsizei bufSize "
          "= %d, void *image = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ConvolutionTarget, target),
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)image);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnConvolutionFilter(context, target, format, type, bufSize, image));
        if (isCallValid)
        {
            context->getnConvolutionFilter(target, format, type, bufSize, image);
        }
        ANGLE_CAPTURE(GetnConvolutionFilter, isCallValid, context, target, format, type, bufSize,
                      image);
    }
}

void GL_APIENTRY GetnHistogram(GLenum target,
                               GLboolean reset,
                               GLenum format,
                               GLenum type,
                               GLsizei bufSize,
                               void *values)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnHistogram",
          "context = %d, GLenum target = %s, GLboolean reset = %s, GLenum format = %s, GLenum type "
          "= %s, GLsizei bufSize = %d, void *values = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::HistogramTargetEXT, target),
          GLbooleanToString(reset), GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)values);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnHistogram(context, target, reset, format, type, bufSize, values));
        if (isCallValid)
        {
            context->getnHistogram(target, reset, format, type, bufSize, values);
        }
        ANGLE_CAPTURE(GetnHistogram, isCallValid, context, target, reset, format, type, bufSize,
                      values);
    }
}

void GL_APIENTRY GetnMapdv(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnMapdv",
          "context = %d, GLenum target = %s, GLenum query = %s, GLsizei bufSize = %d, GLdouble *v "
          "= 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target),
          GLenumToString(GLenumGroup::MapQuery, query), bufSize, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetnMapdv(context, target, query, bufSize, v));
        if (isCallValid)
        {
            context->getnMapdv(target, query, bufSize, v);
        }
        ANGLE_CAPTURE(GetnMapdv, isCallValid, context, target, query, bufSize, v);
    }
}

void GL_APIENTRY GetnMapfv(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnMapfv",
          "context = %d, GLenum target = %s, GLenum query = %s, GLsizei bufSize = %d, GLfloat *v = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target),
          GLenumToString(GLenumGroup::MapQuery, query), bufSize, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetnMapfv(context, target, query, bufSize, v));
        if (isCallValid)
        {
            context->getnMapfv(target, query, bufSize, v);
        }
        ANGLE_CAPTURE(GetnMapfv, isCallValid, context, target, query, bufSize, v);
    }
}

void GL_APIENTRY GetnMapiv(GLenum target, GLenum query, GLsizei bufSize, GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnMapiv",
          "context = %d, GLenum target = %s, GLenum query = %s, GLsizei bufSize = %d, GLint *v = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MapTarget, target),
          GLenumToString(GLenumGroup::MapQuery, query), bufSize, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetnMapiv(context, target, query, bufSize, v));
        if (isCallValid)
        {
            context->getnMapiv(target, query, bufSize, v);
        }
        ANGLE_CAPTURE(GetnMapiv, isCallValid, context, target, query, bufSize, v);
    }
}

void GL_APIENTRY GetnMinmax(GLenum target,
                            GLboolean reset,
                            GLenum format,
                            GLenum type,
                            GLsizei bufSize,
                            void *values)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnMinmax",
          "context = %d, GLenum target = %s, GLboolean reset = %s, GLenum format = %s, GLenum type "
          "= %s, GLsizei bufSize = %d, void *values = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MinmaxTargetEXT, target),
          GLbooleanToString(reset), GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)values);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnMinmax(context, target, reset, format, type, bufSize, values));
        if (isCallValid)
        {
            context->getnMinmax(target, reset, format, type, bufSize, values);
        }
        ANGLE_CAPTURE(GetnMinmax, isCallValid, context, target, reset, format, type, bufSize,
                      values);
    }
}

void GL_APIENTRY GetnPixelMapfv(GLenum map, GLsizei bufSize, GLfloat *values)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnPixelMapfv",
          "context = %d, GLenum map = %s, GLsizei bufSize = %d, GLfloat *values = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::PixelMap, map), bufSize, (uintptr_t)values);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetnPixelMapfv(context, map, bufSize, values));
        if (isCallValid)
        {
            context->getnPixelMapfv(map, bufSize, values);
        }
        ANGLE_CAPTURE(GetnPixelMapfv, isCallValid, context, map, bufSize, values);
    }
}

void GL_APIENTRY GetnPixelMapuiv(GLenum map, GLsizei bufSize, GLuint *values)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnPixelMapuiv",
          "context = %d, GLenum map = %s, GLsizei bufSize = %d, GLuint *values = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PixelMap, map), bufSize, (uintptr_t)values);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetnPixelMapuiv(context, map, bufSize, values));
        if (isCallValid)
        {
            context->getnPixelMapuiv(map, bufSize, values);
        }
        ANGLE_CAPTURE(GetnPixelMapuiv, isCallValid, context, map, bufSize, values);
    }
}

void GL_APIENTRY GetnPixelMapusv(GLenum map, GLsizei bufSize, GLushort *values)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnPixelMapusv",
          "context = %d, GLenum map = %s, GLsizei bufSize = %d, GLushort *values = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::PixelMap, map), bufSize, (uintptr_t)values);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetnPixelMapusv(context, map, bufSize, values));
        if (isCallValid)
        {
            context->getnPixelMapusv(map, bufSize, values);
        }
        ANGLE_CAPTURE(GetnPixelMapusv, isCallValid, context, map, bufSize, values);
    }
}

void GL_APIENTRY GetnPolygonStipple(GLsizei bufSize, GLubyte *pattern)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnPolygonStipple",
          "context = %d, GLsizei bufSize = %d, GLubyte *pattern = 0x%016" PRIxPTR "", CID(context),
          bufSize, (uintptr_t)pattern);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetnPolygonStipple(context, bufSize, pattern));
        if (isCallValid)
        {
            context->getnPolygonStipple(bufSize, pattern);
        }
        ANGLE_CAPTURE(GetnPolygonStipple, isCallValid, context, bufSize, pattern);
    }
}

void GL_APIENTRY GetnSeparableFilter(GLenum target,
                                     GLenum format,
                                     GLenum type,
                                     GLsizei rowBufSize,
                                     void *row,
                                     GLsizei columnBufSize,
                                     void *column,
                                     void *span)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnSeparableFilter",
          "context = %d, GLenum target = %s, GLenum format = %s, GLenum type = %s, GLsizei "
          "rowBufSize = %d, void *row = 0x%016" PRIxPTR
          ", GLsizei columnBufSize = %d, void *column = 0x%016" PRIxPTR
          ", void *span = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::SeparableTargetEXT, target),
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), rowBufSize, (uintptr_t)row, columnBufSize,
          (uintptr_t)column, (uintptr_t)span);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateGetnSeparableFilter(context, target, format, type, rowBufSize,
                                                        row, columnBufSize, column, span));
        if (isCallValid)
        {
            context->getnSeparableFilter(target, format, type, rowBufSize, row, columnBufSize,
                                         column, span);
        }
        ANGLE_CAPTURE(GetnSeparableFilter, isCallValid, context, target, format, type, rowBufSize,
                      row, columnBufSize, column, span);
    }
}

void GL_APIENTRY
GetnTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnTexImage",
          "context = %d, GLenum target = %s, GLint level = %d, GLenum format = %s, GLenum type = "
          "%s, GLsizei bufSize = %d, void *pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnTexImage(context, target, level, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->getnTexImage(target, level, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(GetnTexImage, isCallValid, context, target, level, format, type, bufSize,
                      pixels);
    }
}

void GL_APIENTRY GetnUniformdv(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformdv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLdouble "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformdv(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformdv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformdv, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY GetnUniformfv(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformfv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLfloat "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformfv(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformfv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformfv, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY GetnUniformiv(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformiv(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformiv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformiv, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY GetnUniformuiv(GLuint program, GLint location, GLsizei bufSize, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glGetnUniformuiv",
          "context = %d, GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLuint "
          "*params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                 = FromGL<ShaderProgramID>(program);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformuiv(context, programPacked, location, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformuiv(programPacked, location, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformuiv, isCallValid, context, programPacked, location, bufSize,
                      params);
    }
}

void GL_APIENTRY InvalidateNamedFramebufferData(GLuint framebuffer,
                                                GLsizei numAttachments,
                                                const GLenum *attachments)
{
    Context *context = GetValidGlobalContext();
    EVENT("glInvalidateNamedFramebufferData",
          "context = %d, GLuint framebuffer = %u, GLsizei numAttachments = %d, const GLenum "
          "*attachments = 0x%016" PRIxPTR "",
          CID(context), framebuffer, numAttachments, (uintptr_t)attachments);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateInvalidateNamedFramebufferData(context, framebufferPacked,
                                                                   numAttachments, attachments));
        if (isCallValid)
        {
            context->invalidateNamedFramebufferData(framebufferPacked, numAttachments, attachments);
        }
        ANGLE_CAPTURE(InvalidateNamedFramebufferData, isCallValid, context, framebufferPacked,
                      numAttachments, attachments);
    }
}

void GL_APIENTRY InvalidateNamedFramebufferSubData(GLuint framebuffer,
                                                   GLsizei numAttachments,
                                                   const GLenum *attachments,
                                                   GLint x,
                                                   GLint y,
                                                   GLsizei width,
                                                   GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glInvalidateNamedFramebufferSubData",
          "context = %d, GLuint framebuffer = %u, GLsizei numAttachments = %d, const GLenum "
          "*attachments = 0x%016" PRIxPTR
          ", GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d",
          CID(context), framebuffer, numAttachments, (uintptr_t)attachments, x, y, width, height);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateInvalidateNamedFramebufferSubData(context, framebufferPacked, numAttachments,
                                                       attachments, x, y, width, height));
        if (isCallValid)
        {
            context->invalidateNamedFramebufferSubData(framebufferPacked, numAttachments,
                                                       attachments, x, y, width, height);
        }
        ANGLE_CAPTURE(InvalidateNamedFramebufferSubData, isCallValid, context, framebufferPacked,
                      numAttachments, attachments, x, y, width, height);
    }
}

void *GL_APIENTRY MapNamedBuffer(GLuint buffer, GLenum access)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMapNamedBuffer", "context = %d, GLuint buffer = %u, GLenum access = %s", CID(context),
          buffer, GLenumToString(GLenumGroup::BufferAccessARB, access));

    void *returnValue;
    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMapNamedBuffer(context, bufferPacked, access));
        if (isCallValid)
        {
            returnValue = context->mapNamedBuffer(bufferPacked, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::MapNamedBuffer, void *>();
        }
        ANGLE_CAPTURE(MapNamedBuffer, isCallValid, context, bufferPacked, access, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::MapNamedBuffer, void *>();
    }
    return returnValue;
}

void *GL_APIENTRY MapNamedBufferRange(GLuint buffer,
                                      GLintptr offset,
                                      GLsizeiptr length,
                                      GLbitfield access)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMapNamedBufferRange",
          "context = %d, GLuint buffer = %u, GLintptr offset = %llu, GLsizeiptr length = %llu, "
          "GLbitfield access = %s",
          CID(context), buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(length),
          GLbitfieldToString(GLenumGroup::BufferAccessMask, access).c_str());

    void *returnValue;
    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMapNamedBufferRange(context, bufferPacked, offset, length, access));
        if (isCallValid)
        {
            returnValue = context->mapNamedBufferRange(bufferPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::MapNamedBufferRange, void *>();
        }
        ANGLE_CAPTURE(MapNamedBufferRange, isCallValid, context, bufferPacked, offset, length,
                      access, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::MapNamedBufferRange, void *>();
    }
    return returnValue;
}

void GL_APIENTRY MemoryBarrierByRegion(GLbitfield barriers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glMemoryBarrierByRegion", "context = %d, GLbitfield barriers = %s", CID(context),
          GLbitfieldToString(GLenumGroup::MemoryBarrierMask, barriers).c_str());

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMemoryBarrierByRegion(context, barriers));
        if (isCallValid)
        {
            context->memoryBarrierByRegion(barriers);
        }
        ANGLE_CAPTURE(MemoryBarrierByRegion, isCallValid, context, barriers);
    }
}

void GL_APIENTRY NamedBufferData(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedBufferData",
          "context = %d, GLuint buffer = %u, GLsizeiptr size = %llu, const void *data = "
          "0x%016" PRIxPTR ", GLenum usage = %s",
          CID(context), buffer, static_cast<unsigned long long>(size), (uintptr_t)data,
          GLenumToString(GLenumGroup::VertexBufferObjectUsage, usage));

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateNamedBufferData(context, bufferPacked, size, data, usage));
        if (isCallValid)
        {
            context->namedBufferData(bufferPacked, size, data, usage);
        }
        ANGLE_CAPTURE(NamedBufferData, isCallValid, context, bufferPacked, size, data, usage);
    }
}

void GL_APIENTRY NamedBufferStorage(GLuint buffer,
                                    GLsizeiptr size,
                                    const void *data,
                                    GLbitfield flags)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedBufferStorage",
          "context = %d, GLuint buffer = %u, GLsizeiptr size = %llu, const void *data = "
          "0x%016" PRIxPTR ", GLbitfield flags = %s",
          CID(context), buffer, static_cast<unsigned long long>(size), (uintptr_t)data,
          GLbitfieldToString(GLenumGroup::MapBufferUsageMask, flags).c_str());

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateNamedBufferStorage(context, bufferPacked, size, data, flags));
        if (isCallValid)
        {
            context->namedBufferStorage(bufferPacked, size, data, flags);
        }
        ANGLE_CAPTURE(NamedBufferStorage, isCallValid, context, bufferPacked, size, data, flags);
    }
}

void GL_APIENTRY NamedBufferSubData(GLuint buffer,
                                    GLintptr offset,
                                    GLsizeiptr size,
                                    const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedBufferSubData",
          "context = %d, GLuint buffer = %u, GLintptr offset = %llu, GLsizeiptr size = %llu, const "
          "void *data = 0x%016" PRIxPTR "",
          CID(context), buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(size), (uintptr_t)data);

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateNamedBufferSubData(context, bufferPacked, offset, size, data));
        if (isCallValid)
        {
            context->namedBufferSubData(bufferPacked, offset, size, data);
        }
        ANGLE_CAPTURE(NamedBufferSubData, isCallValid, context, bufferPacked, offset, size, data);
    }
}

void GL_APIENTRY NamedFramebufferDrawBuffer(GLuint framebuffer, GLenum buf)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedFramebufferDrawBuffer", "context = %d, GLuint framebuffer = %u, GLenum buf = %s",
          CID(context), framebuffer, GLenumToString(GLenumGroup::ColorBuffer, buf));

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateNamedFramebufferDrawBuffer(context, framebufferPacked, buf));
        if (isCallValid)
        {
            context->namedFramebufferDrawBuffer(framebufferPacked, buf);
        }
        ANGLE_CAPTURE(NamedFramebufferDrawBuffer, isCallValid, context, framebufferPacked, buf);
    }
}

void GL_APIENTRY NamedFramebufferDrawBuffers(GLuint framebuffer, GLsizei n, const GLenum *bufs)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glNamedFramebufferDrawBuffers",
        "context = %d, GLuint framebuffer = %u, GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR
        "",
        CID(context), framebuffer, n, (uintptr_t)bufs);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNamedFramebufferDrawBuffers(
                                                             context, framebufferPacked, n, bufs));
        if (isCallValid)
        {
            context->namedFramebufferDrawBuffers(framebufferPacked, n, bufs);
        }
        ANGLE_CAPTURE(NamedFramebufferDrawBuffers, isCallValid, context, framebufferPacked, n,
                      bufs);
    }
}

void GL_APIENTRY NamedFramebufferParameteri(GLuint framebuffer, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedFramebufferParameteri",
          "context = %d, GLuint framebuffer = %u, GLenum pname = %s, GLint param = %d",
          CID(context), framebuffer, GLenumToString(GLenumGroup::FramebufferParameterName, pname),
          param);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateNamedFramebufferParameteri(context, framebufferPacked, pname, param));
        if (isCallValid)
        {
            context->namedFramebufferParameteri(framebufferPacked, pname, param);
        }
        ANGLE_CAPTURE(NamedFramebufferParameteri, isCallValid, context, framebufferPacked, pname,
                      param);
    }
}

void GL_APIENTRY NamedFramebufferReadBuffer(GLuint framebuffer, GLenum src)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedFramebufferReadBuffer", "context = %d, GLuint framebuffer = %u, GLenum src = %s",
          CID(context), framebuffer, GLenumToString(GLenumGroup::ColorBuffer, src));

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateNamedFramebufferReadBuffer(context, framebufferPacked, src));
        if (isCallValid)
        {
            context->namedFramebufferReadBuffer(framebufferPacked, src);
        }
        ANGLE_CAPTURE(NamedFramebufferReadBuffer, isCallValid, context, framebufferPacked, src);
    }
}

void GL_APIENTRY NamedFramebufferRenderbuffer(GLuint framebuffer,
                                              GLenum attachment,
                                              GLenum renderbuffertarget,
                                              GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedFramebufferRenderbuffer",
          "context = %d, GLuint framebuffer = %u, GLenum attachment = %s, GLenum "
          "renderbuffertarget = %s, GLuint renderbuffer = %u",
          CID(context), framebuffer, GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateNamedFramebufferRenderbuffer(context, framebufferPacked, attachment,
                                                  renderbuffertarget, renderbufferPacked));
        if (isCallValid)
        {
            context->namedFramebufferRenderbuffer(framebufferPacked, attachment, renderbuffertarget,
                                                  renderbufferPacked);
        }
        ANGLE_CAPTURE(NamedFramebufferRenderbuffer, isCallValid, context, framebufferPacked,
                      attachment, renderbuffertarget, renderbufferPacked);
    }
}

void GL_APIENTRY NamedFramebufferTexture(GLuint framebuffer,
                                         GLenum attachment,
                                         GLuint texture,
                                         GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedFramebufferTexture",
          "context = %d, GLuint framebuffer = %u, GLenum attachment = %s, GLuint texture = %u, "
          "GLint level = %d",
          CID(context), framebuffer, GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          texture, level);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateNamedFramebufferTexture(context, framebufferPacked, attachment,
                                                            texturePacked, level));
        if (isCallValid)
        {
            context->namedFramebufferTexture(framebufferPacked, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE(NamedFramebufferTexture, isCallValid, context, framebufferPacked, attachment,
                      texturePacked, level);
    }
}

void GL_APIENTRY NamedFramebufferTextureLayer(GLuint framebuffer,
                                              GLenum attachment,
                                              GLuint texture,
                                              GLint level,
                                              GLint layer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedFramebufferTextureLayer",
          "context = %d, GLuint framebuffer = %u, GLenum attachment = %s, GLuint texture = %u, "
          "GLint level = %d, GLint layer = %d",
          CID(context), framebuffer, GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          texture, level, layer);

    if (context)
    {
        FramebufferID framebufferPacked               = FromGL<FramebufferID>(framebuffer);
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNamedFramebufferTextureLayer(
                                                             context, framebufferPacked, attachment,
                                                             texturePacked, level, layer));
        if (isCallValid)
        {
            context->namedFramebufferTextureLayer(framebufferPacked, attachment, texturePacked,
                                                  level, layer);
        }
        ANGLE_CAPTURE(NamedFramebufferTextureLayer, isCallValid, context, framebufferPacked,
                      attachment, texturePacked, level, layer);
    }
}

void GL_APIENTRY NamedRenderbufferStorage(GLuint renderbuffer,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedRenderbufferStorage",
          "context = %d, GLuint renderbuffer = %u, GLenum internalformat = %s, GLsizei width = %d, "
          "GLsizei height = %d",
          CID(context), renderbuffer, GLenumToString(GLenumGroup::InternalFormat, internalformat),
          width, height);

    if (context)
    {
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateNamedRenderbufferStorage(context, renderbufferPacked,
                                                             internalformat, width, height));
        if (isCallValid)
        {
            context->namedRenderbufferStorage(renderbufferPacked, internalformat, width, height);
        }
        ANGLE_CAPTURE(NamedRenderbufferStorage, isCallValid, context, renderbufferPacked,
                      internalformat, width, height);
    }
}

void GL_APIENTRY NamedRenderbufferStorageMultisample(GLuint renderbuffer,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glNamedRenderbufferStorageMultisample",
          "context = %d, GLuint renderbuffer = %u, GLsizei samples = %d, GLenum internalformat = "
          "%s, GLsizei width = %d, GLsizei height = %d",
          CID(context), renderbuffer, samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        RenderbufferID renderbufferPacked             = FromGL<RenderbufferID>(renderbuffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateNamedRenderbufferStorageMultisample(context, renderbufferPacked, samples,
                                                         internalformat, width, height));
        if (isCallValid)
        {
            context->namedRenderbufferStorageMultisample(renderbufferPacked, samples,
                                                         internalformat, width, height);
        }
        ANGLE_CAPTURE(NamedRenderbufferStorageMultisample, isCallValid, context, renderbufferPacked,
                      samples, internalformat, width, height);
    }
}

void GL_APIENTRY ReadnPixels(GLint x,
                             GLint y,
                             GLsizei width,
                             GLsizei height,
                             GLenum format,
                             GLenum type,
                             GLsizei bufSize,
                             void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glReadnPixels",
          "context = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, "
          "GLenum format = %s, GLenum type = %s, GLsizei bufSize = %d, void *data = 0x%016" PRIxPTR
          "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadnPixels(context, x, y, width, height, format, type, bufSize, data));
        if (isCallValid)
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE(ReadnPixels, isCallValid, context, x, y, width, height, format, type, bufSize,
                      data);
    }
}

void GL_APIENTRY TextureBarrier()
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureBarrier", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateTextureBarrier(context));
        if (isCallValid)
        {
            context->textureBarrier();
        }
        ANGLE_CAPTURE(TextureBarrier, isCallValid, context);
    }
}

void GL_APIENTRY TextureBuffer(GLuint texture, GLenum internalformat, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureBuffer",
          "context = %d, GLuint texture = %u, GLenum internalformat = %s, GLuint buffer = %u",
          CID(context), texture, GLenumToString(GLenumGroup::InternalFormat, internalformat),
          buffer);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTextureBuffer(context, texturePacked, internalformat, bufferPacked));
        if (isCallValid)
        {
            context->textureBuffer(texturePacked, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE(TextureBuffer, isCallValid, context, texturePacked, internalformat,
                      bufferPacked);
    }
}

void GL_APIENTRY TextureBufferRange(GLuint texture,
                                    GLenum internalformat,
                                    GLuint buffer,
                                    GLintptr offset,
                                    GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureBufferRange",
          "context = %d, GLuint texture = %u, GLenum internalformat = %s, GLuint buffer = %u, "
          "GLintptr offset = %llu, GLsizeiptr size = %llu",
          CID(context), texture, GLenumToString(GLenumGroup::InternalFormat, internalformat),
          buffer, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureBufferRange(context, texturePacked, internalformat,
                                                       bufferPacked, offset, size));
        if (isCallValid)
        {
            context->textureBufferRange(texturePacked, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(TextureBufferRange, isCallValid, context, texturePacked, internalformat,
                      bufferPacked, offset, size);
    }
}

void GL_APIENTRY TextureParameterIiv(GLuint texture, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glTextureParameterIiv",
        "context = %d, GLuint texture = %u, GLenum pname = %s, const GLint *params = 0x%016" PRIxPTR
        "",
        CID(context), texture, GLenumToString(GLenumGroup::TextureParameterName, pname),
        (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureParameterIiv(context, texturePacked, pname, params));
        if (isCallValid)
        {
            context->textureParameterIiv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE(TextureParameterIiv, isCallValid, context, texturePacked, pname, params);
    }
}

void GL_APIENTRY TextureParameterIuiv(GLuint texture, GLenum pname, const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureParameterIuiv",
          "context = %d, GLuint texture = %u, GLenum pname = %s, const GLuint *params = "
          "0x%016" PRIxPTR "",
          CID(context), texture, GLenumToString(GLenumGroup::TextureParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureParameterIuiv(context, texturePacked, pname, params));
        if (isCallValid)
        {
            context->textureParameterIuiv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE(TextureParameterIuiv, isCallValid, context, texturePacked, pname, params);
    }
}

void GL_APIENTRY TextureParameterf(GLuint texture, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureParameterf",
          "context = %d, GLuint texture = %u, GLenum pname = %s, GLfloat param = %f", CID(context),
          texture, GLenumToString(GLenumGroup::TextureParameterName, pname), param);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureParameterf(context, texturePacked, pname, param));
        if (isCallValid)
        {
            context->textureParameterf(texturePacked, pname, param);
        }
        ANGLE_CAPTURE(TextureParameterf, isCallValid, context, texturePacked, pname, param);
    }
}

void GL_APIENTRY TextureParameterfv(GLuint texture, GLenum pname, const GLfloat *param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureParameterfv",
          "context = %d, GLuint texture = %u, GLenum pname = %s, const GLfloat *param = "
          "0x%016" PRIxPTR "",
          CID(context), texture, GLenumToString(GLenumGroup::TextureParameterName, pname),
          (uintptr_t)param);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureParameterfv(context, texturePacked, pname, param));
        if (isCallValid)
        {
            context->textureParameterfv(texturePacked, pname, param);
        }
        ANGLE_CAPTURE(TextureParameterfv, isCallValid, context, texturePacked, pname, param);
    }
}

void GL_APIENTRY TextureParameteri(GLuint texture, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureParameteri",
          "context = %d, GLuint texture = %u, GLenum pname = %s, GLint param = %d", CID(context),
          texture, GLenumToString(GLenumGroup::TextureParameterName, pname), param);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureParameteri(context, texturePacked, pname, param));
        if (isCallValid)
        {
            context->textureParameteri(texturePacked, pname, param);
        }
        ANGLE_CAPTURE(TextureParameteri, isCallValid, context, texturePacked, pname, param);
    }
}

void GL_APIENTRY TextureParameteriv(GLuint texture, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        "glTextureParameteriv",
        "context = %d, GLuint texture = %u, GLenum pname = %s, const GLint *param = 0x%016" PRIxPTR
        "",
        CID(context), texture, GLenumToString(GLenumGroup::TextureParameterName, pname),
        (uintptr_t)param);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureParameteriv(context, texturePacked, pname, param));
        if (isCallValid)
        {
            context->textureParameteriv(texturePacked, pname, param);
        }
        ANGLE_CAPTURE(TextureParameteriv, isCallValid, context, texturePacked, pname, param);
    }
}

void GL_APIENTRY TextureStorage1D(GLuint texture,
                                  GLsizei levels,
                                  GLenum internalformat,
                                  GLsizei width)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureStorage1D",
          "context = %d, GLuint texture = %u, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d",
          CID(context), texture, levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTextureStorage1D(context, texturePacked, levels, internalformat, width));
        if (isCallValid)
        {
            context->textureStorage1D(texturePacked, levels, internalformat, width);
        }
        ANGLE_CAPTURE(TextureStorage1D, isCallValid, context, texturePacked, levels, internalformat,
                      width);
    }
}

void GL_APIENTRY TextureStorage2D(GLuint texture,
                                  GLsizei levels,
                                  GLenum internalformat,
                                  GLsizei width,
                                  GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureStorage2D",
          "context = %d, GLuint texture = %u, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d",
          CID(context), texture, levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTextureStorage2D(context, texturePacked, levels,
                                                                   internalformat, width, height));
        if (isCallValid)
        {
            context->textureStorage2D(texturePacked, levels, internalformat, width, height);
        }
        ANGLE_CAPTURE(TextureStorage2D, isCallValid, context, texturePacked, levels, internalformat,
                      width, height);
    }
}

void GL_APIENTRY TextureStorage2DMultisample(GLuint texture,
                                             GLsizei samples,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureStorage2DMultisample",
          "context = %d, GLuint texture = %u, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLboolean fixedsamplelocations = %s",
          CID(context), texture, samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTextureStorage2DMultisample(context, texturePacked, samples, internalformat,
                                                 width, height, fixedsamplelocations));
        if (isCallValid)
        {
            context->textureStorage2DMultisample(texturePacked, samples, internalformat, width,
                                                 height, fixedsamplelocations);
        }
        ANGLE_CAPTURE(TextureStorage2DMultisample, isCallValid, context, texturePacked, samples,
                      internalformat, width, height, fixedsamplelocations);
    }
}

void GL_APIENTRY TextureStorage3D(GLuint texture,
                                  GLsizei levels,
                                  GLenum internalformat,
                                  GLsizei width,
                                  GLsizei height,
                                  GLsizei depth)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureStorage3D",
          "context = %d, GLuint texture = %u, GLsizei levels = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d",
          CID(context), texture, levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureStorage3D(context, texturePacked, levels, internalformat,
                                                     width, height, depth));
        if (isCallValid)
        {
            context->textureStorage3D(texturePacked, levels, internalformat, width, height, depth);
        }
        ANGLE_CAPTURE(TextureStorage3D, isCallValid, context, texturePacked, levels, internalformat,
                      width, height, depth);
    }
}

void GL_APIENTRY TextureStorage3DMultisample(GLuint texture,
                                             GLsizei samples,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureStorage3DMultisample",
          "context = %d, GLuint texture = %u, GLsizei samples = %d, GLenum internalformat = %s, "
          "GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLboolean "
          "fixedsamplelocations = %s",
          CID(context), texture, samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTextureStorage3DMultisample(context, texturePacked, samples, internalformat,
                                                 width, height, depth, fixedsamplelocations));
        if (isCallValid)
        {
            context->textureStorage3DMultisample(texturePacked, samples, internalformat, width,
                                                 height, depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE(TextureStorage3DMultisample, isCallValid, context, texturePacked, samples,
                      internalformat, width, height, depth, fixedsamplelocations);
    }
}

void GL_APIENTRY TextureSubImage1D(GLuint texture,
                                   GLint level,
                                   GLint xoffset,
                                   GLsizei width,
                                   GLenum format,
                                   GLenum type,
                                   const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureSubImage1D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLsizei width "
          "= %d, GLenum format = %s, GLenum type = %s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, width,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTextureSubImage1D(context, texturePacked, level, xoffset, width,
                                                      format, type, pixels));
        if (isCallValid)
        {
            context->textureSubImage1D(texturePacked, level, xoffset, width, format, type, pixels);
        }
        ANGLE_CAPTURE(TextureSubImage1D, isCallValid, context, texturePacked, level, xoffset, width,
                      format, type, pixels);
    }
}

void GL_APIENTRY TextureSubImage2D(GLuint texture,
                                   GLint level,
                                   GLint xoffset,
                                   GLint yoffset,
                                   GLsizei width,
                                   GLsizei height,
                                   GLenum format,
                                   GLenum type,
                                   const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureSubImage2D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset "
          "= %d, GLsizei width = %d, GLsizei height = %d, GLenum format = %s, GLenum type = %s, "
          "const void *pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, width, height,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTextureSubImage2D(context, texturePacked, level, xoffset, yoffset, width,
                                       height, format, type, pixels));
        if (isCallValid)
        {
            context->textureSubImage2D(texturePacked, level, xoffset, yoffset, width, height,
                                       format, type, pixels);
        }
        ANGLE_CAPTURE(TextureSubImage2D, isCallValid, context, texturePacked, level, xoffset,
                      yoffset, width, height, format, type, pixels);
    }
}

void GL_APIENTRY TextureSubImage3D(GLuint texture,
                                   GLint level,
                                   GLint xoffset,
                                   GLint yoffset,
                                   GLint zoffset,
                                   GLsizei width,
                                   GLsizei height,
                                   GLsizei depth,
                                   GLenum format,
                                   GLenum type,
                                   const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTextureSubImage3D",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset "
          "= %d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLenum type = %s, const void *pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTextureSubImage3D(context, texturePacked, level, xoffset, yoffset, zoffset,
                                       width, height, depth, format, type, pixels));
        if (isCallValid)
        {
            context->textureSubImage3D(texturePacked, level, xoffset, yoffset, zoffset, width,
                                       height, depth, format, type, pixels);
        }
        ANGLE_CAPTURE(TextureSubImage3D, isCallValid, context, texturePacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, type, pixels);
    }
}

void GL_APIENTRY TransformFeedbackBufferBase(GLuint xfb, GLuint index, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTransformFeedbackBufferBase",
          "context = %d, GLuint xfb = %u, GLuint index = %u, GLuint buffer = %u", CID(context), xfb,
          index, buffer);

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateTransformFeedbackBufferBase(context, xfb, index, bufferPacked));
        if (isCallValid)
        {
            context->transformFeedbackBufferBase(xfb, index, bufferPacked);
        }
        ANGLE_CAPTURE(TransformFeedbackBufferBase, isCallValid, context, xfb, index, bufferPacked);
    }
}

void GL_APIENTRY TransformFeedbackBufferRange(GLuint xfb,
                                              GLuint index,
                                              GLuint buffer,
                                              GLintptr offset,
                                              GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT("glTransformFeedbackBufferRange",
          "context = %d, GLuint xfb = %u, GLuint index = %u, GLuint buffer = %u, GLintptr offset = "
          "%llu, GLsizeiptr size = %llu",
          CID(context), xfb, index, buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(size));

    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTransformFeedbackBufferRange(context, xfb, index, bufferPacked, offset, size));
        if (isCallValid)
        {
            context->transformFeedbackBufferRange(xfb, index, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(TransformFeedbackBufferRange, isCallValid, context, xfb, index, bufferPacked,
                      offset, size);
    }
}

GLboolean GL_APIENTRY UnmapNamedBuffer(GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glUnmapNamedBuffer", "context = %d, GLuint buffer = %u", CID(context), buffer);

    GLboolean returnValue;
    if (context)
    {
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUnmapNamedBuffer(context, bufferPacked));
        if (isCallValid)
        {
            returnValue = context->unmapNamedBuffer(bufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::UnmapNamedBuffer, GLboolean>();
        }
        ANGLE_CAPTURE(UnmapNamedBuffer, isCallValid, context, bufferPacked, returnValue);
    }
    else
    {
        returnValue = GetDefaultReturnValue<EntryPoint::UnmapNamedBuffer, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY VertexArrayAttribBinding(GLuint vaobj, GLuint attribindex, GLuint bindingindex)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexArrayAttribBinding",
          "context = %d, GLuint vaobj = %u, GLuint attribindex = %u, GLuint bindingindex = %u",
          CID(context), vaobj, attribindex, bindingindex);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexArrayAttribBinding(context, vaobjPacked, attribindex, bindingindex));
        if (isCallValid)
        {
            context->vertexArrayAttribBinding(vaobjPacked, attribindex, bindingindex);
        }
        ANGLE_CAPTURE(VertexArrayAttribBinding, isCallValid, context, vaobjPacked, attribindex,
                      bindingindex);
    }
}

void GL_APIENTRY VertexArrayAttribFormat(GLuint vaobj,
                                         GLuint attribindex,
                                         GLint size,
                                         GLenum type,
                                         GLboolean normalized,
                                         GLuint relativeoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexArrayAttribFormat",
          "context = %d, GLuint vaobj = %u, GLuint attribindex = %u, GLint size = %d, GLenum type "
          "= %s, GLboolean normalized = %s, GLuint relativeoffset = %u",
          CID(context), vaobj, attribindex, size,
          GLenumToString(GLenumGroup::VertexAttribType, type), GLbooleanToString(normalized),
          relativeoffset);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateVertexArrayAttribFormat(context, vaobjPacked, attribindex, size,
                                                            type, normalized, relativeoffset));
        if (isCallValid)
        {
            context->vertexArrayAttribFormat(vaobjPacked, attribindex, size, type, normalized,
                                             relativeoffset);
        }
        ANGLE_CAPTURE(VertexArrayAttribFormat, isCallValid, context, vaobjPacked, attribindex, size,
                      type, normalized, relativeoffset);
    }
}

void GL_APIENTRY VertexArrayAttribIFormat(GLuint vaobj,
                                          GLuint attribindex,
                                          GLint size,
                                          GLenum type,
                                          GLuint relativeoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexArrayAttribIFormat",
          "context = %d, GLuint vaobj = %u, GLuint attribindex = %u, GLint size = %d, GLenum type "
          "= %s, GLuint relativeoffset = %u",
          CID(context), vaobj, attribindex, size,
          GLenumToString(GLenumGroup::VertexAttribType, type), relativeoffset);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateVertexArrayAttribIFormat(context, vaobjPacked, attribindex,
                                                             size, type, relativeoffset));
        if (isCallValid)
        {
            context->vertexArrayAttribIFormat(vaobjPacked, attribindex, size, type, relativeoffset);
        }
        ANGLE_CAPTURE(VertexArrayAttribIFormat, isCallValid, context, vaobjPacked, attribindex,
                      size, type, relativeoffset);
    }
}

void GL_APIENTRY VertexArrayAttribLFormat(GLuint vaobj,
                                          GLuint attribindex,
                                          GLint size,
                                          GLenum type,
                                          GLuint relativeoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexArrayAttribLFormat",
          "context = %d, GLuint vaobj = %u, GLuint attribindex = %u, GLint size = %d, GLenum type "
          "= %s, GLuint relativeoffset = %u",
          CID(context), vaobj, attribindex, size,
          GLenumToString(GLenumGroup::VertexAttribType, type), relativeoffset);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateVertexArrayAttribLFormat(context, vaobjPacked, attribindex,
                                                             size, type, relativeoffset));
        if (isCallValid)
        {
            context->vertexArrayAttribLFormat(vaobjPacked, attribindex, size, type, relativeoffset);
        }
        ANGLE_CAPTURE(VertexArrayAttribLFormat, isCallValid, context, vaobjPacked, attribindex,
                      size, type, relativeoffset);
    }
}

void GL_APIENTRY VertexArrayBindingDivisor(GLuint vaobj, GLuint bindingindex, GLuint divisor)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexArrayBindingDivisor",
          "context = %d, GLuint vaobj = %u, GLuint bindingindex = %u, GLuint divisor = %u",
          CID(context), vaobj, bindingindex, divisor);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexArrayBindingDivisor(context, vaobjPacked, bindingindex, divisor));
        if (isCallValid)
        {
            context->vertexArrayBindingDivisor(vaobjPacked, bindingindex, divisor);
        }
        ANGLE_CAPTURE(VertexArrayBindingDivisor, isCallValid, context, vaobjPacked, bindingindex,
                      divisor);
    }
}

void GL_APIENTRY VertexArrayElementBuffer(GLuint vaobj, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexArrayElementBuffer", "context = %d, GLuint vaobj = %u, GLuint buffer = %u",
          CID(context), vaobj, buffer);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateVertexArrayElementBuffer(context, vaobjPacked, bufferPacked));
        if (isCallValid)
        {
            context->vertexArrayElementBuffer(vaobjPacked, bufferPacked);
        }
        ANGLE_CAPTURE(VertexArrayElementBuffer, isCallValid, context, vaobjPacked, bufferPacked);
    }
}

void GL_APIENTRY VertexArrayVertexBuffer(GLuint vaobj,
                                         GLuint bindingindex,
                                         GLuint buffer,
                                         GLintptr offset,
                                         GLsizei stride)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexArrayVertexBuffer",
          "context = %d, GLuint vaobj = %u, GLuint bindingindex = %u, GLuint buffer = %u, GLintptr "
          "offset = %llu, GLsizei stride = %d",
          CID(context), vaobj, bindingindex, buffer, static_cast<unsigned long long>(offset),
          stride);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        BufferID bufferPacked                         = FromGL<BufferID>(buffer);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateVertexArrayVertexBuffer(context, vaobjPacked, bindingindex,
                                                            bufferPacked, offset, stride));
        if (isCallValid)
        {
            context->vertexArrayVertexBuffer(vaobjPacked, bindingindex, bufferPacked, offset,
                                             stride);
        }
        ANGLE_CAPTURE(VertexArrayVertexBuffer, isCallValid, context, vaobjPacked, bindingindex,
                      bufferPacked, offset, stride);
    }
}

void GL_APIENTRY VertexArrayVertexBuffers(GLuint vaobj,
                                          GLuint first,
                                          GLsizei count,
                                          const GLuint *buffers,
                                          const GLintptr *offsets,
                                          const GLsizei *strides)
{
    Context *context = GetValidGlobalContext();
    EVENT("glVertexArrayVertexBuffers",
          "context = %d, GLuint vaobj = %u, GLuint first = %u, GLsizei count = %d, const GLuint "
          "*buffers = 0x%016" PRIxPTR ", const GLintptr *offsets = 0x%016" PRIxPTR
          ", const GLsizei *strides = 0x%016" PRIxPTR "",
          CID(context), vaobj, first, count, (uintptr_t)buffers, (uintptr_t)offsets,
          (uintptr_t)strides);

    if (context)
    {
        VertexArrayID vaobjPacked                     = FromGL<VertexArrayID>(vaobj);
        const BufferID *buffersPacked                 = FromGL<const BufferID *>(buffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateVertexArrayVertexBuffers(context, vaobjPacked, first, count,
                                                             buffersPacked, offsets, strides));
        if (isCallValid)
        {
            context->vertexArrayVertexBuffers(vaobjPacked, first, count, buffersPacked, offsets,
                                              strides);
        }
        ANGLE_CAPTURE(VertexArrayVertexBuffers, isCallValid, context, vaobjPacked, first, count,
                      buffersPacked, offsets, strides);
    }
}
}  // namespace gl
