//
// C++ Interface: sharetray
//
// Description:
//
//
// Author: Oleksandr Shneyder <o.shneyder@phoca-gmbh.de>, (C) 2006-2018
//         Mike Gabriel <mike.gabriel@das-netzwerkteam.de>, (C) 2011-2018
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SHARETRAY_H
#define SHARETRAY_H
#include <QMainWindow>
#include "ui_dlg.h"

class QMenu;
class QLocalServer;
class SimpleLocalSocket;
class AccessAction;
class QSystemTrayIcon;
class MessageBox;
class QAction;
class QSocketNotifier;

/**
	@author Oleksandr Shneyder <o.schneydr@phoca-gmbh.de>
*/
class ShareTray : public QMainWindow
{
	Q_OBJECT
public:
	ShareTray();
	~ShareTray();
	// Unix signal handlers.
	static void keybintSignalHandler(int unused);
	static void termSignalHandler(int unused);
	static void abortSignalHandler(int unused);
	static void hupSignalHandler(int unused);
	// desktop sharing socket
	QString getSocketAnswer(QString message);
	void closeSocket(SimpleLocalSocket* sock);
	// entry point for incoming connections
	bool acceptConnections();
private:
	enum {BLACK,WHITE} current_list;
	bool parseParameter(QString param);
	QMenu* menu;
	QWidget* mainWnd;
	QAction* actStart;
	QAction* actStop;
	QAction* actWhite;
	QAction* actBlack;
	QSystemTrayIcon* trayIcon;
	QLocalServer* serverSocket;
	QString socketFname;
	QString lockFname;
	QString sharingGroup;
	MessageBox* mbox;
	QStringList userWhiteList;
	QStringList userBlackList;
	QStringList systemwideWhiteList;
	QStringList systemwideBlackList;
	Ui::mwnd ui;
	bool menuClose;
protected:
	void closeEvent ( QCloseEvent* event );

public slots:
	// Qt signal handlers.
	void handleSigKeybInt();
	void handleSigTerm();
	void handleSigAbort();
	void handleSigHup();
	void slotMenuClose();
private slots:
	void slotStopSharing();
	void slotStartSharing();
	void slotServerConnection();
	void slotCloseConnection(AccessAction* action);
	void slotTimer();
	void slotWhiteList();
	void slotBlackList();
	void slotAboutQt();
	void slotAbout();
	void slotMsgClose(QAbstractButton*);
	void slotMsgOkCancel(QAbstractButton* button);
	void slotDelListItem();
	void slotUpdateLockFile();
private:
	int getAccess(QString user, QString host);
	void trayMessage(QString title, QString text);
	bool isProcessRunning(QString pid);
	void loadSystemSettings();
	void loadUserSettings();
	void saveUserSettings();
	void setTrayIcon();
	void showList();
	// unix file sockets for signal handler communication (unix <-> Qt)
	static int sigkeybintFd[2];
	static int sigtermFd[2];
	static int sigabortFd[2];
	static int sighupFd[2];
	QSocketNotifier *snKeybInt;
	QSocketNotifier *snTerm;
	QSocketNotifier *snAbort;
	QSocketNotifier *snHup;
};

#endif
