/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CloseConnectionException;
import Ice.Connection;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.LocalException;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.ProtocolException;
import Ice.RequestFailedException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownUserException;
import IceInternal.BasicStream;
import IceInternal.LocalExceptionWrapper;
import IceInternal.Protocol;
import IceInternal.Reference;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Outgoing {
    private Connection _connection;
    private Reference _reference;
    private LocalException _exception;
    private int _state;
    private BasicStream _stream;
    public Outgoing next;

    public Outgoing(Connection connection, Reference reference, String string, OperationMode operationMode, Hashtable hashtable) {
        this._connection = connection;
        this._reference = reference;
        this._state = 0;
        this._stream = new BasicStream(reference.getInstance());
        this.writeHeader(string, operationMode, hashtable);
    }

    public void reset(Reference reference, String string, OperationMode operationMode, Hashtable hashtable) {
        this._reference = reference;
        this._state = 0;
        this._exception = null;
        this._stream.reset();
        this.writeHeader(string, operationMode, hashtable);
    }

    public boolean invoke() throws LocalExceptionWrapper {
        this._stream.endWriteEncaps();
        this._state = 1;
        switch (this._reference.getMode()) {
            case 0: {
                this._connection.sendRequest(this._stream, this);
                if (this._exception != null) {
                    if (this._exception instanceof CloseConnectionException || this._exception instanceof ObjectNotExistException) {
                        throw this._exception;
                    }
                    throw new LocalExceptionWrapper(this._exception, false);
                }
                if (this._state != 3) break;
                return false;
            }
            case 1: {
                this._connection.sendRequest(this._stream, null);
                break;
            }
            case 2: {
                this._connection.finishBatchRequest(this._stream);
                break;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    public void abort(LocalException localException) throws LocalExceptionWrapper {
        int n = this._reference.getMode();
        if (n == 2) {
            this._connection.abortBatchRequest();
            throw new LocalExceptionWrapper(localException, false);
        }
        throw localException;
    }

    public void finished(BasicStream basicStream) {
        if (basicStream != this._stream) {
            this._stream.swap(basicStream);
        }
        byte by = this._stream.readByte();
        switch (by) {
            case 0: {
                this._stream.startReadEncaps();
                this._state = 2;
                break;
            }
            case 1: {
                this._stream.startReadEncaps();
                this._state = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                RequestFailedException requestFailedException = null;
                switch (by) {
                    case 2: {
                        requestFailedException = new ObjectNotExistException();
                        break;
                    }
                    case 3: {
                        requestFailedException = new FacetNotExistException();
                        break;
                    }
                    case 4: {
                        requestFailedException = new OperationNotExistException();
                        break;
                    }
                }
                requestFailedException.id = new Identity();
                requestFailedException.id.__read(this._stream);
                String[] stringArray = this._stream.readStringSeq();
                if (stringArray.length > 0) {
                    if (stringArray.length > 1) {
                        throw new MarshalException();
                    }
                    requestFailedException.facet = stringArray[0];
                } else {
                    requestFailedException.facet = "";
                }
                requestFailedException.operation = this._stream.readString();
                this._exception = requestFailedException;
                this._state = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                UnknownException unknownException = null;
                switch (by) {
                    case 7: {
                        unknownException = new UnknownException();
                        break;
                    }
                    case 5: {
                        unknownException = new UnknownLocalException();
                        break;
                    }
                    case 6: {
                        unknownException = new UnknownUserException();
                        break;
                    }
                }
                unknownException.unknown = this._stream.readString();
                this._exception = unknownException;
                this._state = 4;
                break;
            }
            default: {
                this._exception = new ProtocolException("unknown reply status");
                this._state = 4;
            }
        }
    }

    public void finished(LocalException localException) {
        this._state = 4;
        this._exception = localException;
    }

    public BasicStream stream() {
        return this._stream;
    }

    private void writeHeader(String string, OperationMode operationMode, Hashtable hashtable) {
        switch (this._reference.getMode()) {
            case 0: 
            case 1: {
                this._stream.writeBlob(Protocol.requestHdr);
                break;
            }
            case 2: {
                this._connection.prepareBatchRequest(this._stream);
                break;
            }
        }
        this._reference.getIdentity().__write(this._stream);
        String string2 = this._reference.getFacet();
        if (string2 == null || string2.length() == 0) {
            this._stream.writeStringSeq(null);
        } else {
            String[] stringArray = new String[]{string2};
            this._stream.writeStringSeq(stringArray);
        }
        this._stream.writeString(string);
        this._stream.writeByte((byte)operationMode.value());
        if (hashtable == null) {
            hashtable = this._reference.getContext();
        }
        int n = hashtable.size();
        this._stream.writeSize(n);
        if (n > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)hashtable.get(string3);
                this._stream.writeString(string3);
                this._stream.writeString(string4);
            }
        }
        this._stream.startWriteEncaps();
    }

    public int state() {
        return this._state;
    }
}

